/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DigitoPara {
    private LinkedList<Integer> numero;
    private List<Integer> multiplicadores = new ArrayList<Integer>();
    private boolean complementar;
    private int modulo;
    private boolean somarIndividual;
    private Map<Integer, String> substituicoes;

    public DigitoPara(String trecho) {
        char[] digitos;
        this.comMultiplicadoresDeAte(2, 9);
        this.mod(11);
        this.substituicoes = new HashMap<Integer, String>();
        this.numero = new LinkedList();
        for (char digito : digitos = trecho.toCharArray()) {
            this.numero.add(Character.getNumericValue(digito));
        }
        Collections.reverse(this.numero);
    }

    public DigitoPara comMultiplicadoresDeAte(int inicio, int fim) {
        this.multiplicadores.clear();
        for (int i = inicio; i <= fim; ++i) {
            this.multiplicadores.add(i);
        }
        return this;
    }

    public DigitoPara comMultiplicadores(Integer ... multiplicadoresEmOrdem) {
        this.multiplicadores = Arrays.asList(multiplicadoresEmOrdem);
        return this;
    }

    public DigitoPara complementarAoModulo() {
        this.complementar = true;
        return this;
    }

    public DigitoPara trocandoPorSeEncontrar(String substituto, Integer ... i) {
        for (Integer integer : i) {
            this.substituicoes.put(integer, substituto);
        }
        return this;
    }

    public DigitoPara mod(int modulo) {
        this.modulo = modulo;
        return this;
    }

    public DigitoPara somandoIndividualmente() {
        this.somarIndividual = true;
        return this;
    }

    public String calcula() {
        int soma = 0;
        int multiplicadorDaVez = 0;
        Iterator iterator2 = this.numero.iterator();
        while (iterator2.hasNext()) {
            int algarismo = (Integer)iterator2.next();
            int multiplicador = this.multiplicadores.get(multiplicadorDaVez);
            int total = algarismo * multiplicador;
            soma += this.somarIndividual ? this.somaDigitos(total) : total;
            multiplicadorDaVez = this.proximoMultiplicador(multiplicadorDaVez);
        }
        int resultado = soma % this.modulo;
        if (this.complementar) {
            resultado = this.modulo - resultado;
        }
        if (this.substituicoes.containsKey(resultado)) {
            return this.substituicoes.get(resultado);
        }
        return String.valueOf(resultado);
    }

    private int somaDigitos(int total) {
        return total / 10 + total % 10;
    }

    private int proximoMultiplicador(int multiplicadorDaVez) {
        if (++multiplicadorDaVez == this.multiplicadores.size()) {
            multiplicadorDaVez = 0;
        }
        return multiplicadorDaVez;
    }

    public DigitoPara addDigito(String digito) {
        this.numero.addFirst(Integer.valueOf(digito));
        return this;
    }
}

