/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.inwords;

import br.com.caelum.stella.inwords.FormatoDeExtenso;
import br.com.caelum.stella.inwords.Messages;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.MissingResourceException;

public class NumericToWordsConverter {
    private final FormatoDeExtenso formato;
    private final Locale locale;

    public NumericToWordsConverter(FormatoDeExtenso formato) {
        this.formato = formato;
        this.locale = Messages.LOCALE_PT_BR;
    }

    public NumericToWordsConverter(FormatoDeExtenso formato, Locale locale) {
        this.formato = formato;
        this.locale = locale;
    }

    public String toWords(long number) {
        try {
            if (number < 0L) {
                throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel transformar n\u00fameros negativos.");
            }
            StringBuffer result = new StringBuffer();
            if (number == 0L) {
                result.append(this.getNumber(0));
            } else {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setGroupingSeparator(',');
                symbols.setDecimalSeparator('.');
                DecimalFormat formatter = new DecimalFormat("###,###", symbols);
                String formattedInt = formatter.format(number);
                String[] ints = formattedInt.split("[,]");
                ThousandBlock[] blocks = new ThousandBlock[ints.length];
                for (int i = 0; i < blocks.length; ++i) {
                    String block = ints[i];
                    blocks[i] = new ThousandBlock(block);
                }
                this.appendIntegers(result, blocks);
                this.appendIntegersUnits(number, result, blocks);
            }
            return result.toString();
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("N\u00famero muito grande para ser transformado em extenso.");
        }
    }

    public String toWords(double number) {
        try {
            if (number < 0.0) {
                throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel transformar n\u00fameros negativos.");
            }
            StringBuffer result = new StringBuffer();
            if (number == 0.0) {
                result.append(this.getNumber(0));
            } else {
                boolean hasInteger;
                String[] parts = this.split(number);
                String formattedInt = parts[0];
                String[] ints = formattedInt.split("[,]");
                ThousandBlock[] blocks = new ThousandBlock[ints.length];
                for (int i = 0; i < blocks.length; ++i) {
                    String block = ints[i];
                    blocks[i] = new ThousandBlock(block);
                }
                String formattedMod = parts[1];
                ThousandBlock modBlock = new ThousandBlock(formattedMod);
                boolean hasMod = !modBlock.isZero();
                boolean bl = hasInteger = blocks.length > 1 || !blocks[blocks.length - 1].isZero();
                if (hasInteger) {
                    this.appendIntegers(result, blocks);
                    this.appendIntegersUnits(number, result, blocks);
                }
                if (hasInteger && hasMod) {
                    result.append(this.getAndSeparator());
                }
                if (hasMod) {
                    this.appendIntegers(result, modBlock);
                    this.appendDecimalUnits(result, modBlock);
                }
            }
            return result.toString();
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("N\u00famero muito grande para ser transformado em extenso.");
        }
    }

    private void appendDecimalUnits(StringBuffer result, ThousandBlock modBlock) {
        result.append(" ");
        if (modBlock.isUnitary()) {
            result.append(this.formato.getUnidadeDecimalNoSingular());
        } else {
            result.append(this.formato.getUnidadeDecimalNoPlural());
        }
    }

    private String[] split(double number) {
        StringBuffer pattern = new StringBuffer();
        pattern.append("###,000.");
        for (int i = 1; i <= this.formato.getCasasDecimais(); ++i) {
            pattern.append("0");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator(',');
        symbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(pattern.toString(), symbols);
        String formatted = decimalFormat.format(number);
        String[] parts = formatted.split("[.]");
        return parts;
    }

    private void appendIntegersUnits(double number, StringBuffer result, ThousandBlock[] blocks) {
        if (blocks.length != 1 || !blocks[0].isZero()) {
            if (number >= 2.0) {
                String unit = this.formato.getUnidadeInteiraNoPlural();
                if (!unit.isEmpty()) {
                    result.append(" ");
                    int length = blocks.length;
                    if (length > 2 && blocks[length - 1].isZero() && blocks[length - 2].isZero()) {
                        result.append(this.getFormatSeparator());
                    }
                    result.append(unit);
                }
            } else {
                String unit = this.formato.getUnidadeInteiraNoSingular();
                if (!unit.isEmpty()) {
                    result.append(" ").append(unit);
                }
            }
        }
    }

    private void appendIntegers(StringBuffer result, ThousandBlock ... blocks) {
        boolean hasStarted = false;
        for (int i = 0; i < blocks.length; ++i) {
            ThousandBlock thousandBlock = blocks[i];
            if (hasStarted && thousandBlock.isZero()) continue;
            int thousandPower = blocks.length - i - 1;
            if (hasStarted) {
                if (thousandBlock.isUnitary()) {
                    result.append(this.getAndSeparator());
                } else if (thousandPower < 1) {
                    result.append(this.getAndSeparator());
                } else {
                    result.append(this.getThousandSeparator());
                }
            }
            result.append(thousandBlock.toWords());
            if (thousandPower > 0) {
                result.append(" ");
                result.append(this.getString("1e" + 3 * thousandPower + "." + (thousandBlock.isUnitary() ? "singular" : "plural")));
            }
            hasStarted = true;
        }
    }

    private String getThousandSeparator() {
        return this.getString("sep.mil");
    }

    private String getTensSeparator() {
        return this.getString("sep.dezena");
    }

    private String getFormatSeparator() {
        return this.getString("sep.formato");
    }

    private String getAndSeparator() {
        return this.getString("sep");
    }

    private String getString(String paramMessage) {
        return Messages.getString("Extenso." + paramMessage, this.locale);
    }

    private String getNumber(int number) {
        DecimalFormat formater = new DecimalFormat("000");
        String formatted = formater.format(number);
        return Messages.getString("Extenso." + formatted, this.locale);
    }

    private final class ThousandBlock {
        private int numberValue;

        public ThousandBlock(String number) {
            if (number.length() > 3) {
                throw new IllegalArgumentException("ThousandBlock deve conter numeros de no maximo 3 digitos.");
            }
            this.numberValue = Integer.parseInt(number);
        }

        public boolean isZero() {
            return this.numberValue == 0;
        }

        public boolean isUnitary() {
            return this.numberValue == 1;
        }

        public String toWords() {
            String result;
            if (this.numberValue <= 20) {
                result = NumericToWordsConverter.this.getNumber(this.numberValue);
            } else if (this.numberValue <= 99) {
                result = this.getNumberUnder100(this.numberValue);
            } else if (this.numberValue == 100) {
                result = NumericToWordsConverter.this.getNumber(100);
            } else {
                int c = this.numberValue / 100 * 100;
                String centena = c == 100 ? NumericToWordsConverter.this.getString("100+?") : NumericToWordsConverter.this.getNumber(c);
                int resto = this.numberValue % 100;
                result = resto == 0 ? centena : centena + NumericToWordsConverter.this.getAndSeparator() + this.getNumberUnder100(resto);
            }
            return result;
        }

        private String getNumberUnder100(int number) {
            String result = null;
            if (number <= 20) {
                result = NumericToWordsConverter.this.getNumber(number);
            } else if (number <= 99) {
                int d = number / 10;
                int u = number % 10;
                String dezena = NumericToWordsConverter.this.getNumber(d * 10);
                if (u == 0) {
                    result = dezena;
                } else {
                    String unidade = NumericToWordsConverter.this.getNumber(u);
                    result = dezena + NumericToWordsConverter.this.getTensSeparator() + unidade;
                }
            }
            return result;
        }
    }
}

