/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoGenerator;
import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

class IEPernambucoNovaValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("(\\d{7})[-](\\d{2})");
    public static final Pattern UNFORMATED = Pattern.compile("(\\d{7})(\\d{2})");

    public IEPernambucoNovaValidator() {
        super(true);
    }

    public IEPernambucoNovaValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEPernambucoNovaValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 2);
        String digitos = unformattedIE.substring(unformattedIE.length() - 2);
        String digitosCalculados = this.calculaDigitos(iESemDigito);
        return digitos.equals(digitosCalculados);
    }

    private String calculaDigitos(String iESemDigito) {
        DigitoPara digitoPara = new DigitoPara(iESemDigito);
        digitoPara.complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11);
        String digito1 = digitoPara.calcula();
        digitoPara.addDigito(digito1);
        String digito2 = digitoPara.calcula();
        return digito1 + digito2;
    }

    @Override
    public String generateRandomValid() {
        String ieSemDigitos = new DigitoGenerator().generate(7);
        String ieComDigitos = ieSemDigitos + this.calculaDigitos(ieSemDigitos);
        if (this.isFormatted) {
            return super.format(ieComDigitos, "#######-##");
        }
        return ieComDigitos;
    }
}

