/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.agenda;

import br.com.salomaotech.genesys.controller.agenda.AgendaClienteCommand;
import br.com.salomaotech.genesys.controller.agenda.AgendaEventos;
import br.com.salomaotech.genesys.controller.agenda.AgendaMetodos;
import br.com.salomaotech.genesys.model.cliente.ComboBoxClientes;
import br.com.salomaotech.genesys.model.colaborador.ComboBoxColaboradores;
import br.com.salomaotech.genesys.view.JFagenda;
import br.com.salomaotech.sistema.swing.MudaIconeJframe;
import java.util.Calendar;

public class AgendaController {
    private final JFagenda view = new JFagenda();
    private final ComboBoxClientes comboBoxClientes;
    private final AgendaMetodos agendaMetodos = new AgendaMetodos(this.view);
    private final AgendaEventos agendaEventos = new AgendaEventos(this.view);
    private final ComboBoxColaboradores comboBoxColaboradores;
    private final ComboBoxColaboradores comboBoxColaboradoresPesquisa;

    public AgendaController() {
        this.comboBoxClientes = new ComboBoxClientes(this.view.jCcadastroNomeCliente, new AgendaClienteCommand(this.view));
        this.comboBoxClientes.preencher();
        this.comboBoxColaboradores = new ComboBoxColaboradores(this.view.jCcadastroColaborador);
        this.comboBoxColaboradores.preencher();
        this.comboBoxColaboradoresPesquisa = new ComboBoxColaboradores(this.view.jCpesquisaColaborador);
        this.comboBoxColaboradoresPesquisa.preencher();
    }

    public void construir() {
        new MudaIconeJframe().alterar("agenda64x", this.view);
        this.view.setVisible(true);
        this.view.setExtendedState(this.view.getExtendedState() | 6);
        this.view.jTabaPrincipal.setSelectedIndex(1);
        this.agendaMetodos.addPopUpMenu();
        this.agendaMetodos.habilitarCampos();
        this.agendaMetodos.setComboBoxColaboradores(this.comboBoxColaboradores);
        this.agendaMetodos.setComboBoxColaboradoresPesquisa(this.comboBoxColaboradoresPesquisa);
        this.agendaMetodos.setComboBoxClientes(this.comboBoxClientes);
        this.agendaMetodos.pesquisar();
        this.agendaEventos.setComboBoxClientes(this.comboBoxClientes);
        this.agendaEventos.setComboBoxColaboradores(this.comboBoxColaboradores);
        this.agendaEventos.setComboBoxColaboradoresPesquisa(this.comboBoxColaboradoresPesquisa);
        this.agendaEventos.setAgendaMetodos(this.agendaMetodos);
        this.agendaEventos.addEventos();
    }

    public AgendaMetodos getMetodos() {
        return this.agendaMetodos;
    }

    public void carregarAgendaVencida() {
        this.construir();
        this.view.jDpesquisaDataInicio.setDate(Calendar.getInstance().getTime());
        this.view.jCpesquisaDataAnterior.setSelected(true);
        this.agendaMetodos.pesquisar();
    }
}

