/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.agenda;

import br.com.salomaotech.genesys.controller.agenda.AgendaMetodos;
import br.com.salomaotech.genesys.controller.agenda.AgendaValidador;
import br.com.salomaotech.genesys.controller.cliente.ClienteController;
import br.com.salomaotech.genesys.controller.colaborador.ColaboradorController;
import br.com.salomaotech.genesys.model.agenda.AgendaModelo;
import br.com.salomaotech.genesys.model.cliente.ComboBoxClientes;
import br.com.salomaotech.genesys.model.colaborador.ComboBoxColaboradores;
import br.com.salomaotech.genesys.view.JFagenda;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class AgendaEventos {
    private final JFagenda view;
    private AgendaMetodos agendaMetodos;
    private ComboBoxClientes comboBoxClientes;
    private ComboBoxColaboradores comboBoxColaboradores;
    private ComboBoxColaboradores comboBoxColaboradoresPesquisa;

    public AgendaEventos(JFagenda view) {
        this.view = view;
    }

    public void setAgendaMetodos(AgendaMetodos agendaMetodos) {
        this.agendaMetodos = agendaMetodos;
    }

    public void setComboBoxClientes(ComboBoxClientes comboBoxClientes) {
        this.comboBoxClientes = comboBoxClientes;
    }

    public void setComboBoxColaboradores(ComboBoxColaboradores comboBoxColaboradores) {
        this.comboBoxColaboradores = comboBoxColaboradores;
    }

    public void setComboBoxColaboradoresPesquisa(ComboBoxColaboradores comboBoxColaboradoresPesquisa) {
        this.comboBoxColaboradoresPesquisa = comboBoxColaboradoresPesquisa;
    }

    public void addEventos() {
        this.view.jBcadastroSalvar.addActionListener(e -> {
            AgendaValidador agendaValidador = new AgendaValidador(this.view);
            if (agendaValidador.isValido()) {
                AgendaModelo agendaModelo = this.agendaMetodos.salvar();
                if (agendaModelo.getId() != 0L) {
                    this.agendaMetodos.popularFormulario(agendaModelo);
                    this.agendaMetodos.habilitarCampos();
                    this.agendaMetodos.pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro salvo com sucesso!");
                } else {
                    JOptionPane.showMessageDialog(null, "Falha ao tentar salvar registro.");
                }
            } else {
                JOptionPane.showMessageDialog(null, agendaValidador.getMensagensErro());
            }
        });
        this.view.jBcadastroExcluir.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Excluir registro?") == 0) {
                if (this.agendaMetodos.excluir()) {
                    this.agendaMetodos.resetarView();
                    this.agendaMetodos.habilitarCampos();
                    this.agendaMetodos.pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro excluido!");
                } else {
                    JOptionPane.showMessageDialog(null, "Registro n\u00e3o excluido!");
                }
            }
        });
        this.view.jTresultados.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AgendaEventos.this.agendaMetodos.abrirCadastro((Long)((AgendaEventos)AgendaEventos.this).view.jTresultados.getModel().getValueAt(((AgendaEventos)AgendaEventos.this).view.jTresultados.getSelectedRow(), 0));
                }
            }
        });
        this.view.jBatalhoCadastro.addActionListener(e -> {
            this.agendaMetodos.resetarView();
            this.agendaMetodos.habilitarCampos();
        });
        this.view.jBatalhoPesquisa.addActionListener(e -> {
            this.view.jTabaPrincipal.setSelectedIndex(1);
            this.view.jTabaPesquisa.setSelectedIndex(0);
        });
        this.view.jBpesquisa.addActionListener(e -> this.agendaMetodos.pesquisar());
        this.view.jBpaginador.addActionListener(e -> this.agendaMetodos.pesquisar());
        this.view.jTpesquisaNomeCliente.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AgendaEventos.this.agendaMetodos.pesquisar();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.view.jBrefreshCliente.addActionListener(e -> this.comboBoxClientes.preencher());
        this.view.jBpesquisaReseta.addActionListener(e -> this.agendaMetodos.resetarViewPesquisa());
        this.view.jBatalhoCadastroCliente.addActionListener(e -> new ClienteController().construir());
        this.view.jBatalhoCadastroColaborador.addActionListener(e -> new ColaboradorController().construir());
        this.view.jBrefreshColaborador.addActionListener(e -> this.comboBoxColaboradores.preencher());
        this.view.jBrefreshColaboradorPesquisa.addActionListener(e -> this.comboBoxColaboradoresPesquisa.preencher());
    }
}

