/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.agenda;

import br.com.salomaotech.genesys.model.agenda.AgendaModelo;
import br.com.salomaotech.genesys.model.agenda.AgendaPesquisa;
import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.cliente.ComboBoxClientes;
import br.com.salomaotech.genesys.model.colaborador.ComboBoxColaboradores;
import br.com.salomaotech.genesys.model.login.Login;
import br.com.salomaotech.genesys.model.usuario.UsuarioModelo;
import br.com.salomaotech.genesys.view.JFagenda;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class AgendaMetodos {
    private final JFagenda view;
    private ComboBoxColaboradores comboBoxColaboradores;
    private ComboBoxColaboradores comboBoxColaboradoresPesquisa;
    private ComboBoxClientes comboBoxClientes;

    public AgendaMetodos(JFagenda view) {
        this.view = view;
    }

    public void setComboBoxColaboradores(ComboBoxColaboradores comboBoxColaboradores) {
        this.comboBoxColaboradores = comboBoxColaboradores;
    }

    public void setComboBoxColaboradoresPesquisa(ComboBoxColaboradores comboBoxColaboradoresPesquisa) {
        this.comboBoxColaboradoresPesquisa = comboBoxColaboradoresPesquisa;
    }

    public void setComboBoxClientes(ComboBoxClientes comboBoxClientes) {
        this.comboBoxClientes = comboBoxClientes;
    }

    public void popularFormulario(AgendaModelo agendaModelo) {
        this.view.setId(agendaModelo.getId());
        this.view.jDcadastroData.setCalendar(agendaModelo.getDataAgenda());
        this.view.jCcadastroHora.setSelectedItem(agendaModelo.getDataHora());
        this.view.jCcadastroMinuto.setSelectedItem(agendaModelo.getDataMinuto());
        this.view.jCcadastroNomeCliente.getEditor().setItem(agendaModelo.getNomeCliente());
        this.view.jTcadastroTelefone.setText(agendaModelo.getTelefone());
        this.view.jTcadastroHistorico.setText(agendaModelo.getObservacoes());
        this.view.jCstatus.setSelectedItem(agendaModelo.getStatus());
        this.comboBoxColaboradores.selecionarItemPorId(agendaModelo.getIdColaborador());
    }

    public void resetarView() {
        AgendaModelo agendaModelo = new AgendaModelo();
        this.popularFormulario(agendaModelo);
        this.view.jTabaPrincipal.setSelectedIndex(0);
        this.view.jCcadastroHora.setSelectedIndex(0);
        this.view.jCcadastroMinuto.setSelectedIndex(0);
        this.view.jCstatus.setSelectedIndex(0);
        this.comboBoxColaboradores.selecionarItemPorId(0L);
        this.view.jCcadastroNomeCliente.requestFocus();
    }

    public void resetarViewPesquisa() {
        this.view.jTpesquisaNomeCliente.setText(null);
        this.view.jDpesquisaDataInicio.setDate(null);
        this.view.jDPesquisaDataFim.setDate(null);
        this.view.jCpesquisaStatus.setSelectedIndex(0);
        this.view.jTabaPesquisa.setSelectedIndex(0);
        this.view.jCpesquisaDataAnterior.setSelected(false);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.comboBoxColaboradoresPesquisa.selecionarItemPorId(0L);
        this.pesquisar();
    }

    public void habilitarCampos() {
        boolean isIdAberto = this.view.getId() != 0L;
        UsuarioModelo usuarioModelo = Login.getLoginModeloLogado();
        this.view.jBatalhoCadastroCliente.setEnabled(usuarioModelo.isRecepcao());
        this.view.jBatalhoCadastro.setEnabled(usuarioModelo.isAdmin() || usuarioModelo.isRecepcao());
        this.view.jBcadastroSalvar.setEnabled(usuarioModelo.isAdmin() || usuarioModelo.isRecepcao());
        this.view.jBcadastroExcluir.setEnabled((usuarioModelo.isAdmin() || usuarioModelo.isRecepcao()) && isIdAberto);
        this.view.jBatalhoCadastroColaborador.setEnabled(usuarioModelo.isAdmin());
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jCcadastroNomeCliente);
        popUp.adicionarMenu(this.view.jTcadastroTelefone);
        popUp.adicionarMenu(this.view.jTcadastroHistorico);
        popUp.adicionarMenu(this.view.jTpesquisaNomeCliente);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new AgendaModelo());
        AgendaModelo agendaModelo = (AgendaModelo)repository.findById(id);
        this.popularFormulario(agendaModelo);
        this.view.jTabaPrincipal.setSelectedIndex(0);
        this.habilitarCampos();
    }

    public AgendaModelo salvar() {
        String nomeCliente = this.view.jCcadastroNomeCliente.getEditor().getItem().toString();
        if (this.comboBoxClientes.getIdSelecionado() > 0L) {
            ClienteModelo clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.comboBoxClientes.getIdSelecionado());
            nomeCliente = clienteModelo.getNome();
        }
        AgendaModelo agendaModelo = new AgendaModelo();
        agendaModelo.setId(this.view.getId());
        agendaModelo.setNomeCliente(nomeCliente);
        agendaModelo.setTelefone(this.view.jTcadastroTelefone.getText());
        agendaModelo.setDataAgenda(this.view.jDcadastroData.getCalendar());
        agendaModelo.setDataHora(this.view.jCcadastroHora.getSelectedItem().toString());
        agendaModelo.setDataMinuto(this.view.jCcadastroMinuto.getSelectedItem().toString());
        agendaModelo.setObservacoes(this.view.jTcadastroHistorico.getText());
        agendaModelo.setStatus(this.view.jCstatus.getSelectedItem().toString());
        agendaModelo.setIdColaborador(this.comboBoxColaboradores.getIdSelecionado());
        new Repository(agendaModelo).save();
        return agendaModelo;
    }

    public boolean excluir() {
        return new Repository(new AgendaModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        AgendaPesquisa agendaPesquisa = new AgendaPesquisa(this.view.jTresultados, this.view.jCpaginador);
        agendaPesquisa.setDataInicialDate(this.view.jDpesquisaDataInicio.getDate());
        agendaPesquisa.setDataFinalDate(this.view.jDPesquisaDataFim.getDate());
        agendaPesquisa.setNomeCliente(this.view.jTpesquisaNomeCliente.getText());
        agendaPesquisa.setStatus(this.view.jCpesquisaStatus.getSelectedItem().toString());
        agendaPesquisa.setIsDataAnterior(this.view.jCpesquisaDataAnterior.isSelected());
        agendaPesquisa.setIdColaborador(this.comboBoxColaboradoresPesquisa.getIdSelecionado());
        agendaPesquisa.pesquisar();
    }
}

