/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.anamnese;

import br.com.salomaotech.genesys.model.anamnese.AnamneseModelo;
import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.view.JFanamnese;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;
import java.util.List;

public class AnamneseMetodos {
    public final JFanamnese view;
    private final long idCliente;

    public AnamneseMetodos(JFanamnese view, long idCliente) {
        this.view = view;
        this.idCliente = idCliente;
        this.carregarAnamnese(idCliente);
    }

    private void carregarAnamnese(long idCliente) {
        JPQL jpql = new JPQL(new AnamneseModelo());
        jpql.addParametroIgual("idCliente", idCliente);
        List anamneseModeloList = new Repository(new AnamneseModelo()).getResults(jpql.construirSelect());
        try {
            this.popularFormulario((AnamneseModelo)anamneseModeloList.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void popularFormulario(AnamneseModelo modelo) {
        this.view.setId(modelo.getId());
        this.view.jCcadastroQ1.setSelected(modelo.isResposta1());
        this.view.jCcadastroQ2.setSelected(modelo.isResposta2());
        this.view.jCcadastroQ3.setSelected(modelo.isResposta3());
        this.view.jCcadastroQ4.setSelected(modelo.isResposta4());
        this.view.jCcadastroQ5.setSelected(modelo.isResposta5());
        this.view.jCcadastroQ6.setSelected(modelo.isResposta6());
        this.view.jCcadastroQ7.setSelected(modelo.isResposta7());
        this.view.jCcadastroQ8.setSelected(modelo.isResposta8());
        this.view.jCcadastroQ9.setSelected(modelo.isResposta9());
        this.view.jCcadastroQ10.setSelected(modelo.isResposta10());
        this.view.jCcadastroQ11.setSelected(modelo.isResposta11());
        this.view.jCcadastroQ12.setSelected(modelo.isResposta12());
        this.view.jCcadastroQ13.setSelected(modelo.isResposta13());
        this.view.jCcadastroQ14.setSelected(modelo.isResposta14());
        this.view.jCcadastroQ15.setSelected(modelo.isResposta15());
        this.view.jCcadastroPressaoArterial.setSelectedItem(modelo.getResposta16());
        this.view.jTcadastroDoencaRespiratoria.setText(modelo.getResposta17());
        this.view.jTcadastroDoencaFamiliar.setText(modelo.getResposta18());
        this.view.jTcadastroAdicionais.setText(modelo.getResposta19());
    }

    public void resetarView() {
        this.popularFormulario(new AnamneseModelo());
        this.view.jCcadastroPressaoArterial.setSelectedItem("Normal");
    }

    public void habilitarCampos() {
        boolean isIdAberto = this.view.getId() != 0L;
        this.view.jBcadastroExcluir.setEnabled(isIdAberto);
        this.view.jBcadastroImprimir.setEnabled(isIdAberto);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTcadastroDoencaRespiratoria);
        popUp.adicionarMenu(this.view.jTcadastroDoencaFamiliar);
        popUp.adicionarMenu(this.view.jTcadastroAdicionais);
    }

    public AnamneseModelo salvar() {
        AnamneseModelo modelo = new AnamneseModelo();
        modelo.setId(this.view.getId());
        modelo.setIdCliente(this.idCliente);
        modelo.setResposta1(this.view.jCcadastroQ1.isSelected());
        modelo.setResposta2(this.view.jCcadastroQ2.isSelected());
        modelo.setResposta3(this.view.jCcadastroQ3.isSelected());
        modelo.setResposta4(this.view.jCcadastroQ4.isSelected());
        modelo.setResposta5(this.view.jCcadastroQ5.isSelected());
        modelo.setResposta6(this.view.jCcadastroQ6.isSelected());
        modelo.setResposta7(this.view.jCcadastroQ7.isSelected());
        modelo.setResposta8(this.view.jCcadastroQ8.isSelected());
        modelo.setResposta9(this.view.jCcadastroQ9.isSelected());
        modelo.setResposta10(this.view.jCcadastroQ10.isSelected());
        modelo.setResposta11(this.view.jCcadastroQ11.isSelected());
        modelo.setResposta12(this.view.jCcadastroQ12.isSelected());
        modelo.setResposta13(this.view.jCcadastroQ13.isSelected());
        modelo.setResposta14(this.view.jCcadastroQ14.isSelected());
        modelo.setResposta15(this.view.jCcadastroQ15.isSelected());
        modelo.setResposta16(String.valueOf(this.view.jCcadastroPressaoArterial.getSelectedItem()));
        modelo.setResposta17(this.view.jTcadastroDoencaRespiratoria.getText());
        modelo.setResposta18(this.view.jTcadastroDoencaFamiliar.getText());
        modelo.setResposta19(this.view.jTcadastroAdicionais.getText());
        new Repository(modelo).save();
        return modelo;
    }

    public boolean excluir() {
        return new Repository(new AnamneseModelo()).delete(this.view.getId());
    }

    public void apresentaDadosCliente() {
        ClienteModelo clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.idCliente);
        this.view.jTnomeClienteApresentaNome.setText(clienteModelo.getNome());
        this.view.jTnomeClienteApresentaTelefone.setText(clienteModelo.getTelefone());
    }
}

