/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.arquivos;

import br.com.salomaotech.genesys.model.configuracoes.PastasCliente;
import br.com.salomaotech.genesys.view.JFcliente;
import br.com.salomaotech.sistema.algoritmos.CriaPastaLocal;
import br.com.salomaotech.sistema.algoritmos.ExecutaProgramaExterno;
import br.com.salomaotech.sistema.algoritmos.ImagemExibe;
import java.awt.Component;
import java.io.File;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public final class ArquivosMetodos {
    private final JFcliente view;

    public ArquivosMetodos(JFcliente view) {
        this.view = view;
        this.resetarView();
    }

    public void resetarView() {
        DefaultTreeModel modelo = (DefaultTreeModel)this.view.jTreeArquivos.getModel();
        DefaultMutableTreeNode novaRaiz = new DefaultMutableTreeNode("Raiz");
        modelo.setRoot(novaRaiz);
        modelo.reload();
        this.limparImagem();
    }

    private void limparImagem() {
        this.view.jPimagemArquivo.removeAll();
        this.view.jPimagemArquivo.repaint();
    }

    private void criarPastaLocal(String idCliente) {
        String pathDestino = new PastasCliente(idCliente).getSubPastaDeArquivosAnexos();
        CriaPastaLocal.criar(pathDestino);
    }

    private void adicionarNos(File diretorio, DefaultMutableTreeNode noPai) {
        File[] arquivos = diretorio.listFiles();
        if (arquivos != null) {
            for (File arquivo : arquivos) {
                DefaultMutableTreeNode noFilho = new DefaultMutableTreeNode(arquivo);
                noPai.add(noFilho);
                if (!arquivo.isDirectory()) continue;
                this.adicionarNos(arquivo, noFilho);
            }
        }
    }

    public void carregarArquivos(String idCliente) {
        this.criarPastaLocal(idCliente);
        this.limparImagem();
        String pathRaiz = new PastasCliente(idCliente).getSubPastaDeArquivosAnexos();
        File diretorioBase = new File(pathRaiz);
        DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(diretorioBase);
        DefaultTreeModel modeloArvore = new DefaultTreeModel(raiz);
        if (diretorioBase.exists() && diretorioBase.isDirectory()) {
            this.adicionarNos(diretorioBase, raiz);
        }
        this.view.jTreeArquivos.setModel(modeloArvore);
        this.view.jTreeArquivos.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof File) {
                    File file = (File)userObject;
                    this.setText(file.getName());
                    this.setIcon(file.isDirectory() ? this.getDefaultClosedIcon() : this.getDefaultLeafIcon());
                }
                return this;
            }
        });
    }

    public void exibirImagem(String pathImagem) {
        try {
            ImagemExibe imagemExibe = new ImagemExibe(this.view.jPimagemArquivo, this.view.jPimagemArquivo.getWidth() - 12, this.view.jPimagemArquivo.getHeight() - 12);
            imagemExibe.exibir(new File(pathImagem).getAbsolutePath());
        }
        catch (Exception ex) {
            this.limparImagem();
        }
    }

    public void abrirPasta(String idCliente) {
        this.criarPastaLocal(idCliente);
        String pathDestino = new PastasCliente(idCliente).getSubPastaDeArquivosAnexos();
        ExecutaProgramaExterno.executarModoDesktop(pathDestino);
    }
}

