/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.atestado;

import br.com.salomaotech.genesys.model.atestado.AtestadoGeraPdf;
import br.com.salomaotech.genesys.model.atestado.AtestadoModelo;
import br.com.salomaotech.genesys.model.atestado.AtestadoPesquisa;
import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.configuracoes.PastasSistema;
import br.com.salomaotech.genesys.view.JFatestado;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class AtestadoMetodos {
    private final JFatestado view;
    private final long idCliente;

    public AtestadoMetodos(JFatestado view, long idCliente) {
        this.view = view;
        this.idCliente = idCliente;
    }

    public void popularFormulario(AtestadoModelo atestadoModelo) {
        this.view.setId(atestadoModelo.getId());
        this.view.jDcadastroData.setCalendar(atestadoModelo.getData());
        this.view.jTcadastroDias.setText(String.valueOf(atestadoModelo.getDias()));
        this.view.jCcadastroHoraInicio.setSelectedItem(atestadoModelo.getHoraInicio());
        this.view.jCcadastroMinutoInicio.setSelectedItem(atestadoModelo.getMinutoInicio());
        this.view.jCcadastroHoraFim.setSelectedItem(atestadoModelo.getHoraFim());
        this.view.jCcadastroMinutoFim.setSelectedItem(atestadoModelo.getMinutoFim());
        this.view.jTcid.setText(atestadoModelo.getCid());
        this.view.setIdCliente(atestadoModelo.getIdCliente());
    }

    public void resetarView() {
        this.popularFormulario(new AtestadoModelo());
        this.view.jThorario.setSelectedIndex(0);
        this.view.jTcadastroDias.setText("0");
        this.view.jCcadastroHoraInicio.setSelectedIndex(0);
        this.view.jCcadastroMinutoInicio.setSelectedIndex(0);
        this.view.jCcadastroHoraFim.setSelectedIndex(0);
        this.view.jCcadastroMinutoFim.setSelectedIndex(0);
    }

    public void resetarViewPesquisa() {
        this.view.jDpesquisaData.setDate(null);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.pesquisar();
    }

    public void habilitarCampos() {
        this.view.jBcadastroExcluir.setEnabled(this.view.getId() != 0L);
        this.view.jBatalhoImprimir.setEnabled(this.view.getId() != 0L);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTcadastroDias);
        popUp.adicionarMenu(this.view.jTcid);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new AtestadoModelo());
        AtestadoModelo atestadoModelo = (AtestadoModelo)repository.findById(id);
        this.popularFormulario(atestadoModelo);
        this.habilitarCampos();
        this.view.jTabaPrincipal.setSelectedIndex(0);
        this.view.jThorario.setSelectedIndex(0);
    }

    public AtestadoModelo salvar() {
        AtestadoModelo atestadoModelo = new AtestadoModelo();
        atestadoModelo.setId(this.view.getId());
        atestadoModelo.setData(this.view.jDcadastroData.getCalendar());
        atestadoModelo.setDias(Integer.parseInt(this.view.jTcadastroDias.getText()));
        atestadoModelo.setHoraInicio(this.view.jCcadastroHoraInicio.getSelectedItem().toString());
        atestadoModelo.setMinutoInicio(this.view.jCcadastroMinutoInicio.getSelectedItem().toString());
        atestadoModelo.setHoraFim(this.view.jCcadastroHoraFim.getSelectedItem().toString());
        atestadoModelo.setMinutoFim(this.view.jCcadastroMinutoFim.getSelectedItem().toString());
        atestadoModelo.setCid(this.view.jTcid.getText());
        atestadoModelo.setIdCliente(this.idCliente);
        new Repository(atestadoModelo).save();
        return atestadoModelo;
    }

    public boolean excluir() {
        new AtestadoGeraPdf(new PastasSistema().getSubPastaImpressao(), this.view.getId()).excluir();
        return new Repository(new AtestadoModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        AtestadoPesquisa atestadoPesquisa = new AtestadoPesquisa(this.view.jTresultados, this.idCliente, this.view.jCpaginador);
        atestadoPesquisa.setData(this.view.jDpesquisaData.getDate());
        atestadoPesquisa.pesquisar();
    }

    public void apresentaDadosCliente() {
        ClienteModelo clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.idCliente);
        this.view.jTnomeClienteApresentaNome.setText(clienteModelo.getNome());
        this.view.jTnomeClienteApresentaTelefone.setText(clienteModelo.getTelefone());
    }

    public void gerarPdf() {
        AtestadoGeraPdf atestadoGeraPdf = new AtestadoGeraPdf(new PastasSistema().getSubPastaImpressao(), this.view.getId());
        atestadoGeraPdf.gerar();
    }
}

