/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.atestado;

import br.com.salomaotech.genesys.view.JFatestado;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.IsStringNumeroValido;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;

public class AtestadoValidador {
    private final JFatestado view;
    private String mensagensErro = "";

    public AtestadoValidador(JFatestado view) {
        this.view = view;
        if (ValidaStringIsEmpty.isEmpty(view.jTcadastroDias.getText())) {
            view.jTcadastroDias.setText("0");
        }
    }

    private boolean isUsandoHorario() {
        if (this.view.jCcadastroHoraInicio.getSelectedIndex() != 0) {
            return true;
        }
        if (this.view.jCcadastroMinutoInicio.getSelectedIndex() != 0) {
            return true;
        }
        if (this.view.jCcadastroHoraFim.getSelectedIndex() != 0) {
            return true;
        }
        return this.view.jCcadastroMinutoFim.getSelectedIndex() != 0;
    }

    public boolean isValido() {
        if (!Datas.isCalendarioValido(this.view.jDcadastroData.getCalendar())) {
            this.mensagensErro = "Data inv\u00e1lida.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            return false;
        }
        if (!IsStringNumeroValido.isNumeroValido(this.view.jTcadastroDias.getText())) {
            this.mensagensErro = "Quantidade de dias inv\u00e1lido.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroDias.requestFocus();
            return false;
        }
        if (this.view.jTcadastroDias.getText().equals("0") && !this.isUsandoHorario()) {
            this.mensagensErro = "\u00c9 necess\u00e1rio informar pelo menos os dias ou o hor\u00e1rio do atestado.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            return false;
        }
        if (!this.view.jTcadastroDias.getText().equals("0") && this.isUsandoHorario()) {
            this.mensagensErro = "N\u00e3o utilize dias e hor\u00e1rio ao mesmo tempo.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            return false;
        }
        return true;
    }

    public String getMensagensErro() {
        return this.mensagensErro;
    }
}

