/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.ativador;

import br.com.salomaotech.genesys.controller.ativador.AtivadorMetodos;
import br.com.salomaotech.genesys.controller.ativador.AtivadorValidador;
import br.com.salomaotech.genesys.view.JFativador;
import br.com.salomaotech.sistema.algoritmos.ExecutaProgramaExterno;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;

public class AtivadorEventos {
    private final JFativador view;
    private AtivadorMetodos ativadorMetodos;

    public AtivadorEventos(JFativador view) {
        this.view = view;
    }

    public void setAtivadorMetodos(AtivadorMetodos ativadorMetodos) {
        this.ativadorMetodos = ativadorMetodos;
    }

    private void ativar() {
        if (new AtivadorValidador(this.view).isValido()) {
            if (this.ativadorMetodos.isAtivar(this.view.jTchave.getText())) {
                JOptionPane.showMessageDialog(null, "Sistema ativado com sucesso! Muito obrigado.");
                JOptionPane.showMessageDialog(null, "Feche o sistema e abra-o novamente.");
                this.view.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "Chave inv\u00e1lida!");
                this.view.jTchave.setText(null);
                this.view.jTchave.requestFocus();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Chave n\u00e3o informada!");
            this.view.jTchave.requestFocus();
        }
    }

    private void colar() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable conteudo = clipboard.getContents(null);
        if (conteudo != null && conteudo.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String texto = (String)conteudo.getTransferData(DataFlavor.stringFlavor);
                this.view.jTchave.setText(texto);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addEventos() {
        this.view.jBativa.addActionListener(e -> this.ativar());
        this.view.jLabrirSuporte.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ExecutaProgramaExterno.abreUrlNoBrowser("https://www.taimber.com/");
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.view.jTchave.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AtivadorEventos.this.ativar();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.view.jBcolaChave.addActionListener(e -> this.colar());
    }
}

