/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.centro_custo;

import br.com.salomaotech.genesys.model.centro_custo.CentroCustoModelo;
import br.com.salomaotech.genesys.model.centro_custo.CentroCustoPesquisa;
import br.com.salomaotech.genesys.view.JFcentroCusto;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class CentroCustoMetodos {
    private final JFcentroCusto view;

    public CentroCustoMetodos(JFcentroCusto view) {
        this.view = view;
    }

    public void popularFormulario(CentroCustoModelo centroCustoModelo) {
        this.view.setId(centroCustoModelo.getId());
        this.view.jTcadastroCodigo.setText(centroCustoModelo.getCodigo());
        this.view.jTcadastroNome.setText(centroCustoModelo.getNome());
    }

    public void resetarView() {
        this.popularFormulario(new CentroCustoModelo());
    }

    public void resetarViewPesquisa() {
        this.view.jTpesquisaNome.setText(null);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.pesquisar();
    }

    public void habilitarCampos() {
        Repository repository = new Repository(new CentroCustoModelo());
        CentroCustoModelo centroCustoModelo = (CentroCustoModelo)repository.findById(this.view.getId());
        this.view.jBcadastroExcluir.setEnabled(centroCustoModelo.isEditavel() && centroCustoModelo.getId() != 0L);
        this.view.jBcadastroSalvar.setEnabled(centroCustoModelo.isEditavel());
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTcadastroCodigo);
        popUp.adicionarMenu(this.view.jTcadastroNome);
        popUp.adicionarMenu(this.view.jTpesquisaNome);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new CentroCustoModelo());
        CentroCustoModelo centroCustoModelo = (CentroCustoModelo)repository.findById(id);
        this.popularFormulario(centroCustoModelo);
        this.habilitarCampos();
        this.view.jTabaPrincipal.setSelectedIndex(0);
    }

    public CentroCustoModelo salvar() {
        CentroCustoModelo centroCustoModelo = new CentroCustoModelo();
        centroCustoModelo.setId(this.view.getId());
        centroCustoModelo.setCodigo(this.view.jTcadastroCodigo.getText());
        centroCustoModelo.setNome(this.view.jTcadastroNome.getText());
        new Repository(centroCustoModelo).save();
        return centroCustoModelo;
    }

    public boolean excluir() {
        return new Repository(new CentroCustoModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        CentroCustoPesquisa centroCustoPesquisa = new CentroCustoPesquisa(this.view.jTresultados, this.view.jCpaginador);
        centroCustoPesquisa.setNome(this.view.jTpesquisaNome.getText());
        centroCustoPesquisa.pesquisar();
    }
}

