/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.centro_custo;

import br.com.salomaotech.genesys.model.centro_custo.CentroCustoModelo;
import br.com.salomaotech.genesys.view.JFcentroCusto;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.List;

public class CentroCustoValidador {
    private final JFcentroCusto view;
    private final long id;
    private String mensagensErro = "";

    public CentroCustoValidador(JFcentroCusto view, long id) {
        this.view = view;
        this.id = id;
    }

    public boolean isValido() {
        Repository repository = new Repository(new CentroCustoModelo());
        if (ValidaStringIsEmpty.isEmpty(this.view.jTcadastroCodigo.getText())) {
            this.mensagensErro = "Informe o c\u00f3digo do centro de custo.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroCodigo.requestFocus();
            return false;
        }
        JPQL jpql = new JPQL(new CentroCustoModelo());
        jpql.addParametroIgual("codigo", this.view.jTcadastroCodigo.getText());
        jpql.addParametroDiferente("id", this.id);
        List resultados = repository.getResults(jpql.construirSelect());
        if (!resultados.isEmpty()) {
            this.mensagensErro = "C\u00f3digo j\u00e1 em uso.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroCodigo.requestFocus();
            return false;
        }
        if (ValidaStringIsEmpty.isEmpty(this.view.jTcadastroNome.getText())) {
            this.mensagensErro = "Informe o nome do centro de custo.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroNome.requestFocus();
            return false;
        }
        return true;
    }

    public String getMensagensErro() {
        return this.mensagensErro;
    }
}

