/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.cliente;

import br.com.salomaotech.genesys.controller.anamnese.AnamneseController;
import br.com.salomaotech.genesys.controller.atestado.AtestadoController;
import br.com.salomaotech.genesys.controller.cliente.ClienteMetodos;
import br.com.salomaotech.genesys.controller.cliente.ClienteValidador;
import br.com.salomaotech.genesys.controller.evolucao.EvolucaoController;
import br.com.salomaotech.genesys.controller.financeiro.FinanceiroController;
import br.com.salomaotech.genesys.controller.receita.ReceitaController;
import br.com.salomaotech.genesys.controller.tratamento.TratamentoController;
import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.cliente.ClientePesquisa;
import br.com.salomaotech.genesys.view.JFcliente;
import br.com.salomaotech.sistema.algoritmos.BuscaCep;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class ClienteEventos {
    private final JFcliente view;
    private ClienteMetodos clienteMetodos;

    public ClienteEventos(JFcliente view) {
        this.view = view;
    }

    public void setClienteMetodos(ClienteMetodos clienteMetodos) {
        this.clienteMetodos = clienteMetodos;
    }

    public void addEventos() {
        this.view.jBatalhoCadastro.addActionListener(e -> {
            this.clienteMetodos.resetarView();
            this.clienteMetodos.habilitarCampos();
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTabaCadastro.setSelectedIndex(0);
            this.view.jTbasicoNome.requestFocus();
        });
        this.view.jBcadastroSalvar.addActionListener(e -> {
            ClienteValidador clienteValidador = new ClienteValidador(this.view, this.view.getId());
            if (clienteValidador.isValido()) {
                ClienteModelo clienteModelo = this.clienteMetodos.salvar();
                if (clienteModelo.getId() != 0L) {
                    this.view.jTabaCadastro.setSelectedIndex(0);
                    this.clienteMetodos.popularFormulario(clienteModelo);
                    this.clienteMetodos.habilitarCampos();
                    new ClientePesquisa(this.view.jTresultados, this.view.jCpaginador).pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro salvo com sucesso!");
                    this.view.jTbasicoNome.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Falha ao tentar salvar registro.");
                }
            } else {
                JOptionPane.showMessageDialog(null, clienteValidador.getMensagensErro());
            }
        });
        this.view.jBcadastroExcluir.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Excluir registro?") == 0) {
                if (this.clienteMetodos.excluir()) {
                    this.clienteMetodos.resetarView();
                    this.clienteMetodos.habilitarCampos();
                    new ClientePesquisa(this.view.jTresultados, this.view.jCpaginador).pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro excluido!");
                    this.view.jTbasicoNome.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Registro n\u00e3o excluido!");
                }
            }
        });
        this.view.jBpesquisa.addActionListener(e -> this.clienteMetodos.pesquisar());
        this.view.jTresultados.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ClienteEventos.this.clienteMetodos.abrirCadastro((Long)((ClienteEventos)ClienteEventos.this).view.jTresultados.getModel().getValueAt(((ClienteEventos)ClienteEventos.this).view.jTresultados.getSelectedRow(), 0));
                }
            }
        });
        this.view.jTresultados.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ClienteEventos.this.clienteMetodos.abrirCadastro((Long)((ClienteEventos)ClienteEventos.this).view.jTresultados.getModel().getValueAt(((ClienteEventos)ClienteEventos.this).view.jTresultados.getSelectedRow(), 0));
            }
        });
        this.view.jTpesquisaNome.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ClienteEventos.this.clienteMetodos.pesquisar();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.view.jTpesquisaTelefone.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ClienteEventos.this.clienteMetodos.pesquisar();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.view.jBenderecoBuscarCep.addActionListener(e -> {
            BuscaCep buscaCep = new BuscaCep();
            buscaCep.buscar(this.view.jFenderecoCep.getText());
            this.view.jTenderecoRua.setText(buscaCep.getLogradouro());
            this.view.jTenderecoBairro.setText(buscaCep.getBairro());
            this.view.jTenderecoCidade.setText(buscaCep.getCidade());
            this.view.jCenderecoUf.setSelectedItem(buscaCep.getUf());
        });
        this.view.jBatalhoPesquisa.addActionListener(e -> {
            this.view.jTabaPrincipal.setSelectedIndex(1);
            this.view.jTpesquisaNome.requestFocus();
        });
        this.view.jBpaginador.addActionListener(e -> this.clienteMetodos.pesquisar());
        this.view.jBpesquisaReseta.addActionListener(e -> this.clienteMetodos.resetarViewPesquisa());
        this.view.jBatalhoTratamentos.addActionListener(e -> new TratamentoController(this.view.getId()).construir());
        this.view.jBatalhoPagamentos.addActionListener(e -> new FinanceiroController().construirContasReceberCliente(this.view.getId()));
        this.view.jBatalhoAnamnese.addActionListener(e -> new AnamneseController(this.view.getId()).construir());
        this.view.jBatalhoEvolucoes.addActionListener(e -> new EvolucaoController(this.view.getId()).construir());
        this.view.jBatalhoReceita.addActionListener(e -> new ReceitaController(this.view.getId()).construir());
        this.view.jBatalhoAtestado.addActionListener(e -> new AtestadoController(this.view.getId()).construir());
    }
}

