/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.cliente;

import br.com.salomaotech.genesys.controller.arquivos.ArquivosMetodos;
import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.cliente.ClientePesquisa;
import br.com.salomaotech.genesys.model.login.Login;
import br.com.salomaotech.genesys.model.usuario.UsuarioModelo;
import br.com.salomaotech.genesys.view.JFcliente;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;
import java.util.Objects;

public class ClienteMetodos {
    private final JFcliente view;
    private final ArquivosMetodos arquivosMetodos;

    public ClienteMetodos(JFcliente view, ArquivosMetodos arquivosMetodos) {
        this.view = view;
        this.arquivosMetodos = arquivosMetodos;
    }

    public void popularFormulario(ClienteModelo clienteModelo) {
        this.view.setId(clienteModelo.getId());
        this.view.jTbasicoNome.setText(clienteModelo.getNome());
        this.view.jFbasicoCpf.setText(clienteModelo.getCpf());
        this.view.jDbasicoDataNascimento.setCalendar(clienteModelo.getNascimento());
        this.view.jCbasicoSexo.setSelectedItem(clienteModelo.getSexo());
        this.view.jCbasicoNacionalidade.setSelectedItem(clienteModelo.getNacionalidade());
        this.view.jFenderecoCep.setText(clienteModelo.getCep());
        this.view.jTenderecoRua.setText(clienteModelo.getRua());
        this.view.jTenderecoQuadra.setText(clienteModelo.getQuadra());
        this.view.jTenderecoLote.setText(clienteModelo.getLote());
        this.view.jTenderecoNumero.setText(clienteModelo.getNumero());
        this.view.jCenderecoUf.setSelectedItem(clienteModelo.getUf());
        this.view.jTenderecoBairro.setText(clienteModelo.getBairro());
        this.view.jTenderecoCidade.setText(clienteModelo.getCidade());
        this.view.jTenderecoComplemento.setText(clienteModelo.getComplemento());
        this.view.jTcontatoTelefone.setText(clienteModelo.getTelefone());
        this.view.jTcontatoEmail.setText(clienteModelo.getEmail());
    }

    public void resetarView() {
        this.popularFormulario(new ClienteModelo());
        this.view.jFbasicoCpf.setValue(null);
        this.view.jCbasicoSexo.setSelectedIndex(0);
        this.view.jCenderecoUf.setSelectedIndex(0);
        this.view.jCbasicoNacionalidade.setSelectedIndex(0);
        this.arquivosMetodos.resetarView();
    }

    public void resetarViewPesquisa() {
        this.view.jTpesquisaNome.setText(null);
        this.view.jTpesquisaTelefone.setText(null);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.pesquisar();
    }

    public void habilitarCampos() {
        boolean isIdAberto = this.view.getId() != 0L;
        this.view.jBatalhoAbrirPastaArquivo.setEnabled(isIdAberto);
        this.view.jBatalhoRefreshArquivos.setEnabled(isIdAberto);
        this.view.jTreeArquivos.setEnabled(isIdAberto);
        UsuarioModelo usuarioModelo = Login.getLoginModeloLogado();
        this.view.jBatalhoAnamnese.setEnabled(usuarioModelo.isOperacional() && isIdAberto);
        this.view.jBatalhoTratamentos.setEnabled((usuarioModelo.isRecepcao() || usuarioModelo.isOperacional()) && isIdAberto);
        this.view.jBatalhoEvolucoes.setEnabled(usuarioModelo.isOperacional() && isIdAberto);
        this.view.jBatalhoReceita.setEnabled(usuarioModelo.isOperacional() && isIdAberto);
        this.view.jBatalhoAtestado.setEnabled(usuarioModelo.isOperacional() && isIdAberto);
        this.view.jBatalhoPagamentos.setEnabled(usuarioModelo.isFinanceiro() && isIdAberto);
        this.view.jBatalhoCadastro.setEnabled(usuarioModelo.isAdmin() || usuarioModelo.isRecepcao());
        this.view.jBcadastroSalvar.setEnabled(usuarioModelo.isAdmin() || usuarioModelo.isRecepcao());
        this.view.jBcadastroExcluir.setEnabled(usuarioModelo.isAdmin() && isIdAberto);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTbasicoNome);
        popUp.adicionarMenu(this.view.jFbasicoCpf);
        popUp.adicionarMenu(this.view.jFenderecoCep);
        popUp.adicionarMenu(this.view.jTenderecoRua);
        popUp.adicionarMenu(this.view.jTenderecoQuadra);
        popUp.adicionarMenu(this.view.jTenderecoLote);
        popUp.adicionarMenu(this.view.jTenderecoNumero);
        popUp.adicionarMenu(this.view.jTenderecoBairro);
        popUp.adicionarMenu(this.view.jTenderecoCidade);
        popUp.adicionarMenu(this.view.jTenderecoComplemento);
        popUp.adicionarMenu(this.view.jTcontatoTelefone);
        popUp.adicionarMenu(this.view.jTcontatoEmail);
        popUp.adicionarMenu(this.view.jTpesquisaNome);
        popUp.adicionarMenu(this.view.jTpesquisaTelefone);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new ClienteModelo());
        ClienteModelo clienteModelo = (ClienteModelo)repository.findById(id);
        this.popularFormulario(clienteModelo);
        this.view.jTabaPrincipal.setSelectedIndex(0);
        this.view.jTabaCadastro.setSelectedIndex(0);
        this.habilitarCampos();
        if (!Objects.isNull(this.arquivosMetodos)) {
            this.arquivosMetodos.carregarArquivos(String.valueOf(id));
        }
    }

    public ClienteModelo salvar() {
        ClienteModelo clienteModelo = new ClienteModelo();
        clienteModelo.setId(this.view.getId());
        clienteModelo.setNome(this.view.jTbasicoNome.getText());
        clienteModelo.setCpf(this.view.jFbasicoCpf.getText());
        clienteModelo.setNascimento(this.view.jDbasicoDataNascimento.getCalendar());
        clienteModelo.setSexo((String)this.view.jCbasicoSexo.getSelectedItem());
        clienteModelo.setNacionalidade((String)this.view.jCbasicoNacionalidade.getSelectedItem());
        clienteModelo.setCep(this.view.jFenderecoCep.getText());
        clienteModelo.setRua(this.view.jTenderecoRua.getText());
        clienteModelo.setQuadra(this.view.jTenderecoQuadra.getText());
        clienteModelo.setLote(this.view.jTenderecoLote.getText());
        clienteModelo.setNumero(this.view.jTenderecoNumero.getText());
        clienteModelo.setUf((String)this.view.jCenderecoUf.getSelectedItem());
        clienteModelo.setBairro(this.view.jTenderecoBairro.getText());
        clienteModelo.setCidade(this.view.jTenderecoCidade.getText());
        clienteModelo.setComplemento(this.view.jTenderecoComplemento.getText());
        clienteModelo.setTelefone(this.view.jTcontatoTelefone.getText());
        clienteModelo.setEmail(this.view.jTcontatoEmail.getText());
        new Repository(clienteModelo).save();
        return clienteModelo;
    }

    public boolean excluir() {
        return new Repository(new ClienteModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        ClientePesquisa clientePesquisa = new ClientePesquisa(this.view.jTresultados, this.view.jCpaginador);
        clientePesquisa.setNome(this.view.jTpesquisaNome.getText());
        clientePesquisa.setTelefone(this.view.jTpesquisaTelefone.getText());
        clientePesquisa.pesquisar();
    }
}

