/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.cliente;

import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.view.JFcliente;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.ValidaCpf;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.List;
import java.util.Objects;

public class ClienteValidador {
    private final JFcliente view;
    private final long id;
    private String mensagensErro = "";

    public ClienteValidador(JFcliente view, long id) {
        this.view = view;
        this.id = id;
    }

    public boolean isValido() {
        List resultados;
        JPQL jpql;
        Repository repository = new Repository(new ClienteModelo());
        if (ValidaStringIsEmpty.isEmpty(this.view.jTbasicoNome.getText())) {
            this.mensagensErro = "Informe o nome do paciente.";
            this.view.jTbasicoNome.requestFocus();
            return false;
        }
        if (!this.view.jFbasicoCpf.getText().equals("   .   .   -  ")) {
            if (!ValidaCpf.isValido(this.view.jFbasicoCpf.getText())) {
                this.mensagensErro = "CPF inv\u00e1lido.";
                this.view.jFbasicoCpf.requestFocus();
                return false;
            }
            jpql = new JPQL(new ClienteModelo());
            jpql.addParametroIgual("cpf", this.view.jFbasicoCpf.getText());
            jpql.addParametroDiferente("id", this.id);
            resultados = repository.getResults(jpql.construirSelect());
            if (!resultados.isEmpty()) {
                this.mensagensErro = "CPF j\u00e1 em uso.";
                this.view.jFbasicoCpf.requestFocus();
                return false;
            }
        }
        if (!Objects.isNull(this.view.jDbasicoDataNascimento.getCalendar()) && !Datas.isCalendarioValido(this.view.jDbasicoDataNascimento.getCalendar())) {
            this.mensagensErro = "Data de nascimento inv\u00e1lida.";
            return false;
        }
        if (ValidaStringIsEmpty.isEmpty(this.view.jTcontatoTelefone.getText())) {
            this.mensagensErro = "Telefone inv\u00e1lido.";
            this.view.jTabaCadastro.setSelectedIndex(2);
            this.view.jTcontatoTelefone.requestFocus();
            return false;
        }
        jpql = new JPQL(new ClienteModelo());
        jpql.addParametroIgual("nome", this.view.jTbasicoNome.getText());
        jpql.addParametroIgual("telefone", this.view.jTcontatoTelefone.getText());
        jpql.addParametroDiferente("id", this.id);
        resultados = repository.getResults(jpql.construirSelect());
        if (!resultados.isEmpty()) {
            this.mensagensErro = "J\u00e1 existe um cadastro com este nome e telefone.";
            this.view.jTabaCadastro.setSelectedIndex(2);
            this.view.jTcontatoTelefone.requestFocus();
            return false;
        }
        return true;
    }

    public String getMensagensErro() {
        return this.mensagensErro;
    }
}

