/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.colaborador;

import br.com.salomaotech.genesys.controller.colaborador.ColaboradorMetodos;
import br.com.salomaotech.genesys.controller.colaborador.ColaboradorValidador;
import br.com.salomaotech.genesys.model.colaborador.ColaboradorModelo;
import br.com.salomaotech.genesys.model.colaborador.ColaboradorPesquisa;
import br.com.salomaotech.genesys.view.JFcolaborador;
import br.com.salomaotech.sistema.algoritmos.BuscaCep;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class ColaboradorEventos {
    private final JFcolaborador view;
    private ColaboradorMetodos colaboradorMetodos;

    public ColaboradorEventos(JFcolaborador view) {
        this.view = view;
    }

    public void setColaboradorMetodos(ColaboradorMetodos colaboradorMetodos) {
        this.colaboradorMetodos = colaboradorMetodos;
    }

    public void addEventos() {
        this.view.jBatalhoCadastro.addActionListener(e -> {
            this.colaboradorMetodos.resetarView();
            this.colaboradorMetodos.habilitarCampos();
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTabaCadastro.setSelectedIndex(0);
            this.view.jTbasicoNome.requestFocus();
        });
        this.view.jBcadastroSalvar.addActionListener(e -> {
            ColaboradorValidador colaboradorValidador = new ColaboradorValidador(this.view, this.view.getId());
            if (colaboradorValidador.isValido()) {
                ColaboradorModelo colaboradorModelo = this.colaboradorMetodos.salvar();
                if (colaboradorModelo.getId() != 0L) {
                    this.view.jTabaCadastro.setSelectedIndex(0);
                    this.colaboradorMetodos.popularFormulario(colaboradorModelo);
                    this.colaboradorMetodos.habilitarCampos();
                    new ColaboradorPesquisa(this.view.jTresultados, this.view.jCpaginador).pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro salvo com sucesso!");
                    this.view.jTbasicoNome.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Falha ao tentar salvar registro.");
                }
            } else {
                JOptionPane.showMessageDialog(null, colaboradorValidador.getMensagensErro());
            }
        });
        this.view.jBcadastroExcluir.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Excluir registro?") == 0) {
                if (this.colaboradorMetodos.excluir()) {
                    this.colaboradorMetodos.resetarView();
                    this.colaboradorMetodos.habilitarCampos();
                    new ColaboradorPesquisa(this.view.jTresultados, this.view.jCpaginador).pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro excluido!");
                    this.view.jTbasicoNome.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Registro n\u00e3o excluido!");
                }
            }
        });
        this.view.jBpesquisa.addActionListener(e -> this.colaboradorMetodos.pesquisar());
        this.view.jTresultados.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColaboradorEventos.this.colaboradorMetodos.abrirCadastro((Long)((ColaboradorEventos)ColaboradorEventos.this).view.jTresultados.getModel().getValueAt(((ColaboradorEventos)ColaboradorEventos.this).view.jTresultados.getSelectedRow(), 0));
                }
            }
        });
        this.view.jTresultados.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ColaboradorEventos.this.colaboradorMetodos.abrirCadastro((Long)((ColaboradorEventos)ColaboradorEventos.this).view.jTresultados.getModel().getValueAt(((ColaboradorEventos)ColaboradorEventos.this).view.jTresultados.getSelectedRow(), 0));
            }
        });
        this.view.jTpesquisaNome.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ColaboradorEventos.this.colaboradorMetodos.pesquisar();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.view.jTpesquisaTelefone.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ColaboradorEventos.this.colaboradorMetodos.pesquisar();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.view.jBenderecoBuscarCep.addActionListener(e -> {
            BuscaCep buscaCep = new BuscaCep();
            buscaCep.buscar(this.view.jFenderecoCep.getText());
            this.view.jTenderecoRua.setText(buscaCep.getLogradouro());
            this.view.jTenderecoBairro.setText(buscaCep.getBairro());
            this.view.jTenderecoCidade.setText(buscaCep.getCidade());
            this.view.jCenderecoUf.setSelectedItem(buscaCep.getUf());
        });
        this.view.jBatalhoPesquisa.addActionListener(e -> {
            this.view.jTabaPrincipal.setSelectedIndex(1);
            this.view.jTpesquisaNome.requestFocus();
        });
        this.view.jBpaginador.addActionListener(e -> this.colaboradorMetodos.pesquisar());
        this.view.jBpesquisaReseta.addActionListener(e -> this.colaboradorMetodos.resetarViewPesquisa());
    }
}

