/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.colaborador;

import br.com.salomaotech.genesys.model.colaborador.ColaboradorModelo;
import br.com.salomaotech.genesys.model.colaborador.ColaboradorPesquisa;
import br.com.salomaotech.genesys.view.JFcolaborador;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class ColaboradorMetodos {
    private final JFcolaborador view;

    public ColaboradorMetodos(JFcolaborador view) {
        this.view = view;
    }

    public void popularFormulario(ColaboradorModelo colaboradorModelo) {
        this.view.setId(colaboradorModelo.getId());
        this.view.jTbasicoNome.setText(colaboradorModelo.getNome());
        this.view.jFbasicoCpf.setText(colaboradorModelo.getCpf());
        this.view.jDbasicoDataNascimento.setCalendar(colaboradorModelo.getNascimento());
        this.view.jCbasicoSexo.setSelectedItem(colaboradorModelo.getSexo());
        this.view.jCbasicoNacionalidade.setSelectedItem(colaboradorModelo.getNacionalidade());
        this.view.jFenderecoCep.setText(colaboradorModelo.getCep());
        this.view.jTenderecoRua.setText(colaboradorModelo.getRua());
        this.view.jTenderecoQuadra.setText(colaboradorModelo.getQuadra());
        this.view.jTenderecoLote.setText(colaboradorModelo.getLote());
        this.view.jTenderecoNumero.setText(colaboradorModelo.getNumero());
        this.view.jCenderecoUf.setSelectedItem(colaboradorModelo.getUf());
        this.view.jTenderecoBairro.setText(colaboradorModelo.getBairro());
        this.view.jTenderecoCidade.setText(colaboradorModelo.getCidade());
        this.view.jTenderecoComplemento.setText(colaboradorModelo.getComplemento());
        this.view.jTcontatoTelefone.setText(colaboradorModelo.getTelefone());
        this.view.jTcontatoEmail.setText(colaboradorModelo.getEmail());
        this.view.jTbasicoRegistro.setText(colaboradorModelo.getRegistro());
    }

    public void resetarView() {
        this.popularFormulario(new ColaboradorModelo());
        this.view.jFbasicoCpf.setValue(null);
        this.view.jCbasicoSexo.setSelectedIndex(0);
        this.view.jCenderecoUf.setSelectedIndex(0);
        this.view.jCbasicoNacionalidade.setSelectedIndex(0);
    }

    public void resetarViewPesquisa() {
        this.view.jTpesquisaNome.setText(null);
        this.view.jTpesquisaTelefone.setText(null);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.pesquisar();
    }

    public void habilitarCampos() {
        boolean isIdAberto = this.view.getId() != 0L;
        this.view.jBcadastroExcluir.setEnabled(isIdAberto);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTbasicoNome);
        popUp.adicionarMenu(this.view.jFbasicoCpf);
        popUp.adicionarMenu(this.view.jFenderecoCep);
        popUp.adicionarMenu(this.view.jTenderecoRua);
        popUp.adicionarMenu(this.view.jTenderecoQuadra);
        popUp.adicionarMenu(this.view.jTenderecoLote);
        popUp.adicionarMenu(this.view.jTenderecoNumero);
        popUp.adicionarMenu(this.view.jTenderecoBairro);
        popUp.adicionarMenu(this.view.jTenderecoCidade);
        popUp.adicionarMenu(this.view.jTenderecoComplemento);
        popUp.adicionarMenu(this.view.jTcontatoTelefone);
        popUp.adicionarMenu(this.view.jTcontatoEmail);
        popUp.adicionarMenu(this.view.jTpesquisaNome);
        popUp.adicionarMenu(this.view.jTpesquisaTelefone);
        popUp.adicionarMenu(this.view.jTbasicoRegistro);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new ColaboradorModelo());
        ColaboradorModelo colaboradorModelo = (ColaboradorModelo)repository.findById(id);
        this.popularFormulario(colaboradorModelo);
        this.view.jTabaPrincipal.setSelectedIndex(0);
        this.view.jTabaCadastro.setSelectedIndex(0);
        this.habilitarCampos();
    }

    public ColaboradorModelo salvar() {
        ColaboradorModelo colaboradorModelo = new ColaboradorModelo();
        colaboradorModelo.setId(this.view.getId());
        colaboradorModelo.setNome(this.view.jTbasicoNome.getText());
        colaboradorModelo.setCpf(this.view.jFbasicoCpf.getText());
        colaboradorModelo.setNascimento(this.view.jDbasicoDataNascimento.getCalendar());
        colaboradorModelo.setSexo((String)this.view.jCbasicoSexo.getSelectedItem());
        colaboradorModelo.setNacionalidade((String)this.view.jCbasicoNacionalidade.getSelectedItem());
        colaboradorModelo.setCep(this.view.jFenderecoCep.getText());
        colaboradorModelo.setRua(this.view.jTenderecoRua.getText());
        colaboradorModelo.setQuadra(this.view.jTenderecoQuadra.getText());
        colaboradorModelo.setLote(this.view.jTenderecoLote.getText());
        colaboradorModelo.setNumero(this.view.jTenderecoNumero.getText());
        colaboradorModelo.setUf((String)this.view.jCenderecoUf.getSelectedItem());
        colaboradorModelo.setBairro(this.view.jTenderecoBairro.getText());
        colaboradorModelo.setCidade(this.view.jTenderecoCidade.getText());
        colaboradorModelo.setComplemento(this.view.jTenderecoComplemento.getText());
        colaboradorModelo.setTelefone(this.view.jTcontatoTelefone.getText());
        colaboradorModelo.setEmail(this.view.jTcontatoEmail.getText());
        colaboradorModelo.setRegistro(this.view.jTbasicoRegistro.getText());
        new Repository(colaboradorModelo).save();
        return colaboradorModelo;
    }

    public boolean excluir() {
        return new Repository(new ColaboradorModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        ColaboradorPesquisa colaboradorPesquisa = new ColaboradorPesquisa(this.view.jTresultados, this.view.jCpaginador);
        colaboradorPesquisa.setNome(this.view.jTpesquisaNome.getText());
        colaboradorPesquisa.setTelefone(this.view.jTpesquisaTelefone.getText());
        colaboradorPesquisa.pesquisar();
    }
}

