/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.configuracoes;

import br.com.salomaotech.genesys.view.JFconfiguracoes;
import br.com.salomaotech.sistema.algoritmos.ArquivoPropriedade;
import br.com.salomaotech.sistema.algoritmos.CopiarArquivosSemDialogo;
import br.com.salomaotech.sistema.jpa.ConexaoSingleton;
import br.com.salomaotech.sistema.jpa.ConfiguracoesConexao;
import br.com.salomaotech.sistema.swing.PopUp;
import java.io.File;
import java.util.Properties;
import javax.swing.JFileChooser;

public class ConfiguracoesMetodos {
    private final JFconfiguracoes view;
    private Properties propriedades = new Properties();
    private final ArquivoPropriedade arquivoPropriedade;

    public ConfiguracoesMetodos(JFconfiguracoes view) {
        this.view = view;
        this.arquivoPropriedade = new ArquivoPropriedade(new ConfiguracoesConexao().getPathArquivo());
        this.propriedades = this.arquivoPropriedade.getProperties();
    }

    public void popularFormulario() {
        try {
            this.view.jTservidor.setText(this.propriedades.getProperty("servidor"));
            this.view.jTlogin.setText(this.propriedades.getProperty("login"));
            this.view.jTsenha.setText(this.propriedades.getProperty("senha"));
            this.view.jTbancoDados.setText(this.propriedades.getProperty("banco"));
            this.view.jTpastaDeArquivos.setText(this.propriedades.getProperty("pasta_raiz"));
            this.view.jTporta.setText(this.propriedades.getProperty("porta"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void habilitarCampos() {
        this.view.jBcadastroExcluir.setEnabled(this.arquivoPropriedade.isArquivoConfiguracaoExiste());
    }

    public boolean popularFormularioSelecionarPastaDeArquivos() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Selecionar pasta de arquivos");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showOpenDialog(null) == 0) {
            this.view.jTpastaDeArquivos.setText(jFileChooser.getSelectedFile().getAbsoluteFile().toString());
            return true;
        }
        return false;
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTservidor);
        popUp.adicionarMenu(this.view.jTlogin);
        popUp.adicionarMenu(this.view.jTsenha);
        popUp.adicionarMenu(this.view.jTbancoDados);
        popUp.adicionarMenu(this.view.jTpastaDeArquivos);
        popUp.adicionarMenu(this.view.jTporta);
    }

    public void salvar() {
        this.propriedades.setProperty("servidor", this.view.jTservidor.getText());
        this.propriedades.setProperty("login", this.view.jTlogin.getText());
        this.propriedades.setProperty("senha", this.view.jTsenha.getText());
        this.propriedades.setProperty("banco", this.view.jTbancoDados.getText());
        this.propriedades.setProperty("pasta_raiz", this.view.jTpastaDeArquivos.getText());
        this.propriedades.setProperty("porta", this.view.jTporta.getText());
        this.arquivoPropriedade.salvar(this.propriedades);
    }

    public boolean excluir() {
        return this.arquivoPropriedade.deletar();
    }

    public boolean conectar() {
        boolean isConectado;
        File fileBackup = new File(new File(this.arquivoPropriedade.absolutePath()).getParent() + "/bkp.txt");
        ConexaoSingleton conexaoSingleton = new ConexaoSingleton();
        boolean isPreconfiguracaoExiste = this.arquivoPropriedade.isArquivoConfiguracaoExiste();
        if (isPreconfiguracaoExiste) {
            CopiarArquivosSemDialogo.copiar(this.arquivoPropriedade.absolutePath(), fileBackup.getAbsolutePath());
        }
        this.salvar();
        conexaoSingleton.fecharConexao();
        conexaoSingleton.abrirConexao("Conexao");
        boolean bl = isConectado = conexaoSingleton.isConexaoAberta() && new File(this.arquivoPropriedade.getProperties().getProperty("pasta_raiz")).exists();
        if (isPreconfiguracaoExiste) {
            CopiarArquivosSemDialogo.copiar(fileBackup.getAbsolutePath(), this.arquivoPropriedade.absolutePath());
            fileBackup.delete();
        } else {
            this.arquivoPropriedade.deletar();
        }
        conexaoSingleton.fecharConexao();
        conexaoSingleton.abrirConexao("Conexao");
        this.propriedades = this.arquivoPropriedade.getProperties();
        this.popularFormulario();
        return isConectado;
    }
}

