/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.empresa;

import br.com.salomaotech.genesys.controller.empresa.EmpresaMetodos;
import br.com.salomaotech.genesys.controller.empresa.EmpresaValidador;
import br.com.salomaotech.genesys.model.empresa.EmpresaModelo;
import br.com.salomaotech.genesys.model.empresa.ImagemEmpresa;
import br.com.salomaotech.genesys.view.JFempresa;
import br.com.salomaotech.sistema.algoritmos.BuscaCep;
import javax.swing.JOptionPane;

public class EmpresaEventos {
    private final JFempresa view;
    private EmpresaMetodos empresaMetodos;

    public EmpresaEventos(JFempresa view) {
        this.view = view;
    }

    public void setEmpresaMetodos(EmpresaMetodos empresaMetodos) {
        this.empresaMetodos = empresaMetodos;
    }

    public void addEventos() {
        this.view.jBcadastroSalvar.addActionListener(e -> {
            EmpresaValidador empresaValidador = new EmpresaValidador(this.view);
            if (empresaValidador.isValido()) {
                EmpresaModelo empresaModelo = this.empresaMetodos.salvar();
                if (empresaModelo.getId() != 0L) {
                    this.empresaMetodos.popularFormulario(empresaModelo);
                    this.empresaMetodos.habilitarCampos();
                    JOptionPane.showMessageDialog(null, "Registro salvo com sucesso!");
                    this.view.jTbasicoNome.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Falha ao tentar salvar registro.");
                }
            } else {
                JOptionPane.showMessageDialog(null, empresaValidador.getMensagensErro());
            }
        });
        this.view.jBcadastroExcluir.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Excluir registro?") == 0) {
                if (this.empresaMetodos.excluir()) {
                    this.empresaMetodos.resetarView();
                    this.empresaMetodos.habilitarCampos();
                    JOptionPane.showMessageDialog(null, "Registro excluido!");
                    this.view.jTbasicoNome.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Registro n\u00e3o excluido!");
                }
            }
        });
        this.view.jBenderecoBuscarCep.addActionListener(e -> {
            BuscaCep buscaCep = new BuscaCep();
            buscaCep.buscar(this.view.jFenderecoCep.getText());
            this.view.jTenderecoRua.setText(buscaCep.getLogradouro());
            this.view.jTenderecoBairro.setText(buscaCep.getBairro());
            this.view.jTenderecoCidade.setText(buscaCep.getCidade());
            this.view.jCenderecoUf.setSelectedItem(buscaCep.getUf());
        });
        this.view.jBadicionaFoto.addActionListener(e -> {
            if (ImagemEmpresa.upload(String.valueOf(this.view.getId()))) {
                ImagemEmpresa.exibir(String.valueOf(this.view.getId()), this.view.jPdadosPerfilFoto);
            }
        });
        this.view.jBremoveFoto.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Excluir foto?") == 0) {
                ImagemEmpresa.remover(String.valueOf(this.view.getId()), this.view.jPdadosPerfilFoto);
            }
        });
    }
}

