/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.empresa;

import br.com.salomaotech.genesys.model.empresa.EmpresaModelo;
import br.com.salomaotech.genesys.model.empresa.EmpresaPesquisa;
import br.com.salomaotech.genesys.model.empresa.ImagemEmpresa;
import br.com.salomaotech.genesys.view.JFempresa;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class EmpresaMetodos {
    private final JFempresa view;

    public EmpresaMetodos(JFempresa view) {
        this.view = view;
    }

    public void popularFormulario(EmpresaModelo empresaModelo) {
        this.view.setId(empresaModelo.getId());
        this.view.jTbasicoNome.setText(empresaModelo.getNome());
        this.view.jFbasicoCnpj.setText(empresaModelo.getCnpj());
        this.view.jFenderecoCep.setText(empresaModelo.getCep());
        this.view.jTenderecoRua.setText(empresaModelo.getRua());
        this.view.jTenderecoQuadra.setText(empresaModelo.getQuadra());
        this.view.jTenderecoLote.setText(empresaModelo.getLote());
        this.view.jTenderecoNumero.setText(empresaModelo.getNumero());
        this.view.jCenderecoUf.setSelectedItem(empresaModelo.getUf());
        this.view.jTenderecoBairro.setText(empresaModelo.getBairro());
        this.view.jTenderecoCidade.setText(empresaModelo.getCidade());
        this.view.jTenderecoComplemento.setText(empresaModelo.getComplemento());
        this.view.jTcontatoTelefone.setText(empresaModelo.getTelefone());
        this.view.jTcontatoEmail.setText(empresaModelo.getEmail());
        ImagemEmpresa.exibir(String.valueOf(empresaModelo.getId()), this.view.jPdadosPerfilFoto);
    }

    public void resetarView() {
        EmpresaModelo empresaModelo = new EmpresaModelo();
        this.popularFormulario(empresaModelo);
        this.view.jFbasicoCnpj.setValue(null);
        this.view.jCenderecoUf.setSelectedIndex(0);
    }

    public void habilitarCampos() {
        boolean isIdAberto = this.view.getId() != 0L;
        this.view.jBcadastroExcluir.setEnabled(isIdAberto);
        this.view.jBadicionaFoto.setEnabled(isIdAberto);
        this.view.jBremoveFoto.setEnabled(isIdAberto);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTbasicoNome);
        popUp.adicionarMenu(this.view.jFbasicoCnpj);
        popUp.adicionarMenu(this.view.jTcontatoTelefone);
        popUp.adicionarMenu(this.view.jTcontatoEmail);
        popUp.adicionarMenu(this.view.jFenderecoCep);
        popUp.adicionarMenu(this.view.jTenderecoRua);
        popUp.adicionarMenu(this.view.jTenderecoQuadra);
        popUp.adicionarMenu(this.view.jTenderecoLote);
        popUp.adicionarMenu(this.view.jTenderecoNumero);
        popUp.adicionarMenu(this.view.jTenderecoBairro);
        popUp.adicionarMenu(this.view.jTenderecoCidade);
        popUp.adicionarMenu(this.view.jTenderecoComplemento);
        popUp.adicionarMenu(this.view.jTcontatoTelefone);
        popUp.adicionarMenu(this.view.jTcontatoEmail);
    }

    public void carregaDadosEmpresa() {
        EmpresaModelo empresaModelo = EmpresaPesquisa.getDadosEmpresa();
        this.popularFormulario(empresaModelo);
    }

    public EmpresaModelo salvar() {
        EmpresaModelo empresaModelo = new EmpresaModelo();
        empresaModelo.setId(this.view.getId());
        empresaModelo.setNome(this.view.jTbasicoNome.getText());
        empresaModelo.setCnpj(this.view.jFbasicoCnpj.getText());
        empresaModelo.setCep(this.view.jFenderecoCep.getText());
        empresaModelo.setRua(this.view.jTenderecoRua.getText());
        empresaModelo.setQuadra(this.view.jTenderecoQuadra.getText());
        empresaModelo.setLote(this.view.jTenderecoLote.getText());
        empresaModelo.setNumero(this.view.jTenderecoNumero.getText());
        empresaModelo.setUf((String)this.view.jCenderecoUf.getSelectedItem());
        empresaModelo.setBairro(this.view.jTenderecoBairro.getText());
        empresaModelo.setCidade(this.view.jTenderecoCidade.getText());
        empresaModelo.setComplemento(this.view.jTenderecoComplemento.getText());
        empresaModelo.setTelefone(this.view.jTcontatoTelefone.getText());
        empresaModelo.setEmail(this.view.jTcontatoEmail.getText());
        new Repository(empresaModelo).save();
        return empresaModelo;
    }

    public boolean excluir() {
        ImagemEmpresa.remover(String.valueOf(this.view.getId()), this.view.jPdadosPerfilFoto);
        return new Repository(new EmpresaModelo()).delete(this.view.getId());
    }
}

