/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.evolucao;

import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.evolucao.EvolucaoModelo;
import br.com.salomaotech.genesys.model.evolucao.EvolucaoPesquisa;
import br.com.salomaotech.genesys.view.JFevolucao;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class EvolucaoMetodos {
    private final JFevolucao view;
    private final long idCliente;

    public EvolucaoMetodos(JFevolucao view, long idCliente) {
        this.view = view;
        this.idCliente = idCliente;
    }

    public void popularFormulario(EvolucaoModelo evolucaoModelo) {
        this.view.setId(evolucaoModelo.getId());
        this.view.setIdCliente(evolucaoModelo.getIdCliente());
        this.view.setIdTratamento(evolucaoModelo.getIdTratamento());
        this.view.jDcadastroData.setCalendar(evolucaoModelo.getData());
        this.view.jTcadastroDescricao.setText(evolucaoModelo.getDescricao());
    }

    public void resetarView() {
        this.popularFormulario(new EvolucaoModelo());
    }

    public void resetarViewPesquisa() {
        this.view.jTpesquisaDescricao.setText(null);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.pesquisar();
    }

    public void habilitarCampos() {
        this.view.jBcadastroExcluir.setEnabled(this.view.getId() != 0L);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTcadastroDescricao);
        popUp.adicionarMenu(this.view.jTpesquisaDescricao);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new EvolucaoModelo());
        EvolucaoModelo evolucaoModelo = (EvolucaoModelo)repository.findById(id);
        this.popularFormulario(evolucaoModelo);
        this.habilitarCampos();
        this.view.jTabaPrincipal.setSelectedIndex(0);
    }

    public EvolucaoModelo salvar() {
        EvolucaoModelo evolucaoModelo = new EvolucaoModelo();
        evolucaoModelo.setId(this.view.getId());
        evolucaoModelo.setData(this.view.jDcadastroData.getCalendar());
        evolucaoModelo.setDescricao(this.view.jTcadastroDescricao.getText());
        evolucaoModelo.setIdCliente(this.idCliente);
        evolucaoModelo.setIdTratamento(this.view.getIdTratamento());
        new Repository(evolucaoModelo).save();
        return evolucaoModelo;
    }

    public boolean excluir() {
        return new Repository(new EvolucaoModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        EvolucaoPesquisa evolucaoPesquisa = new EvolucaoPesquisa(this.view.jTresultados, this.idCliente, this.view.jCpaginador);
        evolucaoPesquisa.setDescricao(this.view.jTpesquisaDescricao.getText());
        evolucaoPesquisa.pesquisar();
    }

    public void apresentaDadosCliente() {
        ClienteModelo clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.idCliente);
        this.view.jTnomeClienteApresentaNome.setText(clienteModelo.getNome());
        this.view.jTnomeClienteApresentaTelefone.setText(clienteModelo.getTelefone());
    }
}

