/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.financeiro;

import br.com.salomaotech.genesys.controller.financeiro.FinanceiroEventos;
import br.com.salomaotech.genesys.controller.financeiro.FinanceiroMetodos;
import br.com.salomaotech.genesys.model.centro_custo.ComboBoxCentroCusto;
import br.com.salomaotech.genesys.model.tratamento.TratamentoModelo;
import br.com.salomaotech.genesys.view.JFfinanceiro;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.MudaIconeJframe;
import java.util.Calendar;

public class FinanceiroController {
    private final JFfinanceiro view = new JFfinanceiro();
    private final ComboBoxCentroCusto comboBoxCentroCustoCadastro;
    private final ComboBoxCentroCusto comboBoxCentroCustoPesquisa;
    private final FinanceiroMetodos financeiroMetodos;
    private final FinanceiroEventos financeiroEventos;

    public FinanceiroController() {
        this.comboBoxCentroCustoCadastro = new ComboBoxCentroCusto(this.view.jCcadastroCentroCusto);
        this.comboBoxCentroCustoPesquisa = new ComboBoxCentroCusto(this.view.jCpesquisaCentroCusto);
        this.financeiroMetodos = new FinanceiroMetodos(this.view);
        this.financeiroEventos = new FinanceiroEventos(this.view);
        this.comboBoxCentroCustoCadastro.preencher();
        this.comboBoxCentroCustoPesquisa.preencher();
        this.financeiroMetodos.setComboBoxCentroCustoCadastro(this.comboBoxCentroCustoCadastro);
        this.financeiroMetodos.setComboBoxCentroCustoPesquisa(this.comboBoxCentroCustoPesquisa);
        this.financeiroEventos.setComboBoxCentroCustoCadastro(this.comboBoxCentroCustoCadastro);
        this.financeiroEventos.setComboBoxCentroCustoPesquisa(this.comboBoxCentroCustoPesquisa);
    }

    public void construir() {
        new MudaIconeJframe().alterar("financeiro64x", this.view);
        this.view.setVisible(true);
        this.view.setExtendedState(this.view.getExtendedState() | 6);
        this.view.jTabaPrincipal.setSelectedIndex(1);
        this.financeiroMetodos.addPopUpMenu();
        this.financeiroMetodos.habilitarCampos();
        this.financeiroMetodos.pesquisar();
        this.financeiroEventos.setFinanceiroMetodos(this.financeiroMetodos);
        this.financeiroEventos.addEventos();
    }

    public void construirContasPagar() {
        this.construir();
        this.view.jDpesquisaDataInicio.setDate(Calendar.getInstance().getTime());
        this.view.jCpesquisaPago.setSelectedItem("Nao");
        this.view.jCpesquisaDataAnterior.setSelected(true);
        this.view.jCpesquisaIsDespesa.setSelectedItem("Pagar");
        this.financeiroMetodos.pesquisar();
    }

    public void construirContasReceber() {
        this.construir();
        this.view.jDpesquisaDataInicio.setDate(Calendar.getInstance().getTime());
        this.view.jCpesquisaPago.setSelectedItem("Nao");
        this.view.jCpesquisaDataAnterior.setSelected(true);
        this.view.jCpesquisaIsDespesa.setSelectedItem("Receber");
        this.financeiroMetodos.pesquisar();
    }

    public void construirContasReceberTratamentos(long idTratamento) {
        TratamentoModelo tratamentoModelo = (TratamentoModelo)new Repository(new TratamentoModelo()).findById(idTratamento);
        this.construir();
        this.view.setIdTratamento(idTratamento);
        this.view.setIdCliente(tratamentoModelo.getIdCliente());
        this.financeiroMetodos.apresentaDadosCliente(tratamentoModelo.getIdCliente());
        this.financeiroMetodos.pesquisar();
    }

    public void construirContasReceberCliente(long idCliente) {
        this.construir();
        this.view.setIdCliente(idCliente);
        this.financeiroMetodos.apresentaDadosCliente(idCliente);
        this.financeiroMetodos.pesquisar();
    }
}

