/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.financeiro;

import br.com.salomaotech.genesys.controller.centro_custo.CentroCustoController;
import br.com.salomaotech.genesys.controller.cliente.ClienteController;
import br.com.salomaotech.genesys.controller.financeiro.FinanceiroMetodos;
import br.com.salomaotech.genesys.controller.financeiro.FinanceiroValidador;
import br.com.salomaotech.genesys.controller.tratamento.TratamentoController;
import br.com.salomaotech.genesys.model.centro_custo.ComboBoxCentroCusto;
import br.com.salomaotech.genesys.model.financeiro.FinanceiroModelo;
import br.com.salomaotech.genesys.view.JFfinanceiro;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class FinanceiroEventos {
    private final JFfinanceiro view;
    private FinanceiroMetodos financeiroMetodos;
    private ComboBoxCentroCusto comboBoxCentroCustoCadastro;
    private ComboBoxCentroCusto comboBoxCentroCustoPesquisa;

    public FinanceiroEventos(JFfinanceiro view) {
        this.view = view;
    }

    public void setFinanceiroMetodos(FinanceiroMetodos financeiroMetodos) {
        this.financeiroMetodos = financeiroMetodos;
    }

    public void setComboBoxCentroCustoCadastro(ComboBoxCentroCusto comboBoxCentroCustoCadastro) {
        this.comboBoxCentroCustoCadastro = comboBoxCentroCustoCadastro;
    }

    public void setComboBoxCentroCustoPesquisa(ComboBoxCentroCusto comboBoxCentroCustoPesquisa) {
        this.comboBoxCentroCustoPesquisa = comboBoxCentroCustoPesquisa;
    }

    public void addEventos() {
        this.view.jBcadastroSalvar.addActionListener(e -> {
            FinanceiroValidador financeiroValidador = new FinanceiroValidador(this.view);
            if (financeiroValidador.isValido()) {
                FinanceiroModelo financeiroModelo = this.financeiroMetodos.salvar();
                if (financeiroModelo.getId() != 0L) {
                    this.financeiroMetodos.popularFormulario(financeiroModelo);
                    this.financeiroMetodos.habilitarCampos();
                    this.financeiroMetodos.pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro salvo com sucesso!");
                    this.view.jTcadastroValor.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Falha ao tentar salvar registro.");
                }
            } else {
                JOptionPane.showMessageDialog(null, financeiroValidador.getMensagensErro());
            }
        });
        this.view.jBcadastroExcluir.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Excluir registro?") == 0) {
                if (this.financeiroMetodos.excluir()) {
                    this.financeiroMetodos.resetarView();
                    this.financeiroMetodos.habilitarCampos();
                    this.financeiroMetodos.pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro excluido!");
                    this.view.jTcadastroValor.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Registro n\u00e3o excluido!");
                }
            }
        });
        this.view.jTresultados.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FinanceiroEventos.this.financeiroMetodos.abrirCadastro((Long)((FinanceiroEventos)FinanceiroEventos.this).view.jTresultados.getModel().getValueAt(((FinanceiroEventos)FinanceiroEventos.this).view.jTresultados.getSelectedRow(), 0));
                }
            }
        });
        this.view.jBatalhoCadastro.addActionListener(e -> {
            this.financeiroMetodos.resetarView();
            this.financeiroMetodos.habilitarCampos();
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroValor.requestFocus();
        });
        this.view.jBatalhoPesquisa.addActionListener(e -> this.view.jTabaPrincipal.setSelectedIndex(1));
        this.view.jBpesquisa.addActionListener(e -> this.financeiroMetodos.pesquisar());
        this.view.jBpaginador.addActionListener(e -> this.financeiroMetodos.pesquisar());
        this.view.jBrefreshCadastroCentroCusto.addActionListener(e -> this.comboBoxCentroCustoCadastro.preencher());
        this.view.jBatalhoCentroCusto.addActionListener(e -> new CentroCustoController().construir());
        this.view.jBpesquisaCentroCusto.addActionListener(e -> new CentroCustoController().construir());
        this.view.jCpesquisaDataAnterior.addActionListener(e -> {
            if (this.view.jCpesquisaDataAnterior.isSelected()) {
                this.view.jDPesquisaDataFim.setDate(null);
            }
        });
        this.view.jBatalhoVisualizarTratamento.addActionListener(e -> {
            new TratamentoController(this.view.getIdCliente()).abrirCadastro(this.view.getIdTratamento());
            this.view.dispose();
        });
        this.view.jBatalhoVisualizarCliente.addActionListener(e -> {
            new ClienteController().abrirCadastro(this.view.getIdCliente());
            this.view.dispose();
        });
        this.view.jBpesquisaReseta.addActionListener(e -> this.financeiroMetodos.resetarViewPesquisa());
        this.view.jBrefreshPesquisaCentroCusto.addActionListener(e -> this.comboBoxCentroCustoPesquisa.preencher());
    }
}

