/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.financeiro;

import br.com.salomaotech.genesys.model.centro_custo.ComboBoxCentroCusto;
import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.financeiro.FinanceiroModelo;
import br.com.salomaotech.genesys.model.financeiro.FinanceiroPesquisa;
import br.com.salomaotech.genesys.model.login.Login;
import br.com.salomaotech.genesys.model.usuario.UsuarioModelo;
import br.com.salomaotech.genesys.view.JFfinanceiro;
import br.com.salomaotech.sistema.algoritmos.BigDecimais;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class FinanceiroMetodos {
    private final JFfinanceiro view;
    private ComboBoxCentroCusto comboBoxCentroCustoCadastro;
    private ComboBoxCentroCusto comboBoxCentroCustoPesquisa;

    public FinanceiroMetodos(JFfinanceiro view) {
        this.view = view;
    }

    public void setComboBoxCentroCustoCadastro(ComboBoxCentroCusto comboBoxCentroCustoCadastro) {
        this.comboBoxCentroCustoCadastro = comboBoxCentroCustoCadastro;
    }

    public void setComboBoxCentroCustoPesquisa(ComboBoxCentroCusto comboBoxCentroCustoPesquisa) {
        this.comboBoxCentroCustoPesquisa = comboBoxCentroCustoPesquisa;
    }

    public void popularFormulario(FinanceiroModelo financeiroModelo) {
        this.view.setId(financeiroModelo.getId());
        this.view.setIdTratamento(financeiroModelo.getIdTratamento());
        this.view.setIdCliente(financeiroModelo.getIdCliente());
        this.view.jDcadastroData.setCalendar(financeiroModelo.getData());
        this.view.jTcadastroValor.setText(financeiroModelo.getValor().toString());
        this.view.jTcadastroDescricao.setText(financeiroModelo.getDescricao());
        this.comboBoxCentroCustoCadastro.selecionarItemPorId(financeiroModelo.getIdCentroCusto());
        this.view.jCcadastroPago.setSelected(financeiroModelo.isIsPago());
        if (financeiroModelo.isIsDespesa()) {
            this.view.jCcadastroIsDespesa.setSelectedIndex(0);
        } else {
            this.view.jCcadastroIsDespesa.setSelectedIndex(1);
        }
    }

    public void resetarView() {
        this.popularFormulario(new FinanceiroModelo());
        this.view.jTcadastroValor.setText(null);
        this.view.jCcadastroIsDespesa.setSelectedIndex(0);
        this.view.jTnomeClienteApresentaNome.setText(null);
        this.view.jTnomeClienteApresentaTelefone.setText(null);
    }

    public void resetarViewPesquisa() {
        this.view.jDpesquisaDataInicio.setDate(null);
        this.view.jDPesquisaDataFim.setDate(null);
        this.comboBoxCentroCustoPesquisa.selecionarItemPorId(0L);
        this.view.jCpesquisaIsDespesa.setSelectedIndex(0);
        this.view.jCpesquisaPago.setSelectedIndex(0);
        this.view.jTabaPesquisa.setSelectedIndex(0);
        this.view.jCpesquisaDataAnterior.setSelected(false);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.pesquisar();
    }

    public void habilitarCampos() {
        boolean isIdAberto = this.view.getId() != 0L;
        boolean isTratamento = this.view.getIdTratamento() != 0L;
        UsuarioModelo usuarioModelo = Login.getLoginModeloLogado();
        this.view.jBatalhoCadastro.setEnabled(usuarioModelo.isAdmin() || usuarioModelo.isFinanceiro());
        this.view.jBcadastroSalvar.setEnabled(usuarioModelo.isAdmin() || usuarioModelo.isFinanceiro());
        this.view.jBcadastroExcluir.setEnabled((usuarioModelo.isAdmin() || usuarioModelo.isFinanceiro()) && isIdAberto);
        this.view.jBatalhoVisualizarTratamento.setEnabled((usuarioModelo.isAdmin() || usuarioModelo.isOperacional()) && isTratamento);
        this.view.jBatalhoVisualizarCliente.setEnabled((usuarioModelo.isAdmin() || usuarioModelo.isOperacional() || usuarioModelo.isRecepcao()) && isTratamento);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTcadastroValor);
        popUp.adicionarMenu(this.view.jTcadastroDescricao);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new FinanceiroModelo());
        FinanceiroModelo financeiroModelo = (FinanceiroModelo)repository.findById(id);
        this.popularFormulario(financeiroModelo);
        this.habilitarCampos();
        this.apresentaDadosCliente(financeiroModelo.getIdCliente());
        this.view.jTabaPrincipal.setSelectedIndex(0);
    }

    public FinanceiroModelo salvar() {
        FinanceiroModelo financeiroModelo = new FinanceiroModelo();
        financeiroModelo.setId(this.view.getId());
        financeiroModelo.setData(this.view.jDcadastroData.getCalendar());
        financeiroModelo.setValor(BigDecimais.formatarParaBigDecimal(this.view.jTcadastroValor.getText()));
        financeiroModelo.setDescricao(this.view.jTcadastroDescricao.getText());
        financeiroModelo.setIdCentroCusto(this.comboBoxCentroCustoCadastro.getIdSelecionado());
        financeiroModelo.setIsDespesa(this.view.jCcadastroIsDespesa.getSelectedIndex() == 0);
        financeiroModelo.setIsPago(this.view.jCcadastroPago.isSelected());
        financeiroModelo.setIdTratamento(this.view.getIdTratamento());
        financeiroModelo.setIdCliente(this.view.getIdCliente());
        new Repository(financeiroModelo).save();
        return financeiroModelo;
    }

    public boolean excluir() {
        return new Repository(new FinanceiroModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        FinanceiroPesquisa financeiroPesquisa = new FinanceiroPesquisa(this.view.jTresultados, this.view.jCpaginador, this.view.jLsaldo);
        financeiroPesquisa.setDataInicialDate(this.view.jDpesquisaDataInicio.getDate());
        financeiroPesquisa.setDataFinalDate(this.view.jDPesquisaDataFim.getDate());
        financeiroPesquisa.setIdCentroCusto(this.comboBoxCentroCustoPesquisa.getIdSelecionado());
        financeiroPesquisa.setPagamentoRealizado(this.view.jCpesquisaPago.getSelectedItem().toString());
        financeiroPesquisa.setPagamentoDespesa(this.view.jCpesquisaIsDespesa.getSelectedItem().toString());
        financeiroPesquisa.setIsDataAnterior(this.view.jCpesquisaDataAnterior.isSelected());
        financeiroPesquisa.setIdTratamento(this.view.getIdTratamento());
        financeiroPesquisa.setIdCliente(this.view.getIdCliente());
        financeiroPesquisa.pesquisar();
    }

    public void apresentaDadosCliente(long idCliente) {
        ClienteModelo clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(idCliente);
        this.view.jTnomeClienteApresentaNome.setText(clienteModelo.getNome());
        this.view.jTnomeClienteApresentaTelefone.setText(clienteModelo.getTelefone());
    }
}

