/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.financeiro;

import br.com.salomaotech.genesys.view.JFfinanceiro;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.IsStringNumeroValido;

public class FinanceiroValidador {
    private final JFfinanceiro view;
    private String mensagensErro = "";

    public FinanceiroValidador(JFfinanceiro view) {
        this.view = view;
    }

    public boolean isValido() {
        if (!Datas.isCalendarioValido(this.view.jDcadastroData.getCalendar())) {
            this.mensagensErro = "Data inv\u00e1lida.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            return false;
        }
        if (!IsStringNumeroValido.isNumeroValido(this.view.jTcadastroValor.getText())) {
            this.mensagensErro = "Valor inv\u00e1lido.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroValor.requestFocus();
            return false;
        }
        if (this.view.jCcadastroCentroCusto.getSelectedIndex() == 0) {
            this.mensagensErro = "Informe o centro de custo.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jCcadastroCentroCusto.requestFocus();
            return false;
        }
        return true;
    }

    public String getMensagensErro() {
        return this.mensagensErro;
    }
}

