/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.novidades;

import br.com.salomaotech.genesys.view.JFnovidades;
import br.com.salomaotech.sistema.algoritmos.ExecutaProgramaExterno;
import br.com.salomaotech.sistema.modelos.ApiModelo;
import br.com.salomaotech.sistema.patterns.Command;
import br.com.salomaotech.sistema.swing.MudaIconeJframe;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class NovidadesMetodos
implements Command {
    public void exibirImagem(String urlImagem, JLabel label) {
        try {
            URL url = new URL(urlImagem);
            BufferedImage image = ImageIO.read(url);
            int maxWidth = label.getWidth();
            int maxHeight = label.getHeight();
            int imageWidth = ((Image)image).getWidth(null);
            int imageHeight = ((Image)image).getHeight(null);
            double scaleFactor = Math.min(1.0 * (double)maxWidth / (double)imageWidth, 1.0 * (double)maxHeight / (double)imageHeight);
            int newWidth = (int)((double)imageWidth * scaleFactor);
            int newHeight = (int)((double)imageHeight * scaleFactor);
            Image scaledImage = image.getScaledInstance(newWidth, newHeight, 4);
            ImageIcon icon = new ImageIcon(scaledImage);
            label.setIcon(icon);
            int x = (maxWidth - newWidth) / 2;
            int y = (maxHeight - newHeight) / 2;
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            label.setBounds(x, y, newWidth, newHeight);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addEventos(JFnovidades view, String urlLink) {
        view.jBbotaoConhecer.addActionListener(e -> ExecutaProgramaExterno.abreUrlNoBrowser(urlLink));
        view.jBbotaoFechar.addActionListener(e -> view.dispose());
    }

    @Override
    public void executar(Object arg) {
        JFnovidades view = new JFnovidades();
        new MudaIconeJframe().alterar("news24x", view);
        ApiModelo api = (ApiModelo)arg;
        view.jLtitulo.setText(api.getTitulo());
        view.jLdescricao.setText(api.getDescricao());
        this.exibirImagem(api.getUrlImagem(), view.jLimagem);
        this.addEventos(view, api.getLink());
        view.setVisible(true);
    }
}

