/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.principal;

import br.com.salomaotech.genesys.model.agenda.AgendaPesquisa;
import br.com.salomaotech.genesys.model.colaborador.ComboBoxColaboradores;
import br.com.salomaotech.genesys.model.login.Login;
import br.com.salomaotech.genesys.model.notificacoes.Notificacoes;
import br.com.salomaotech.genesys.model.usuario.UsuarioModelo;
import br.com.salomaotech.genesys.view.JFprincipal;
import javax.swing.table.DefaultTableModel;

public class PrincipalMetodos {
    private final JFprincipal view;
    private AgendaPesquisa agendaPesquisa;
    private ComboBoxColaboradores comboBoxColaboradoresPesquisa;

    public PrincipalMetodos(JFprincipal view) {
        this.view = view;
        this.agendaPesquisa = new AgendaPesquisa(view.jTresultados, view.jCpaginador);
    }

    public void setComboBoxColaboradoresPesquisa(ComboBoxColaboradores comboBoxColaboradoresPesquisa) {
        this.comboBoxColaboradoresPesquisa = comboBoxColaboradoresPesquisa;
    }

    public void carregaAgendaDia() {
        this.agendaPesquisa.setDataInicialDate(this.view.jDpesquisaDataInicio.getDate());
        this.agendaPesquisa.setStatus(this.view.jCpesquisaStatus.getSelectedItem().toString());
        this.agendaPesquisa.pesquisar();
    }

    public void carregaNotificacoes() {
        Notificacoes notificacoes = new Notificacoes();
        this.view.jMagenda.setText("Agenda - " + notificacoes.getAgenda());
        this.view.jMfinanceiroPagar.setText("Pagar - " + notificacoes.getFinanceiroPagar());
        this.view.jMfinanceiroReceber.setText("Receber - " + notificacoes.getFinanceiroReceber());
        this.view.jMnotificacoes.setText("Notifica\u00e7\u00f5es - " + notificacoes.total());
    }

    public void resetarViewPesquisa() {
        this.view.jDpesquisaDataInicio.setDate(null);
        this.view.jCpesquisaStatus.setSelectedIndex(0);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.comboBoxColaboradoresPesquisa.selecionarItemPorId(0L);
        this.pesquisar();
    }

    public void pesquisar() {
        this.agendaPesquisa = new AgendaPesquisa(this.view.jTresultados, this.view.jCpaginador);
        this.agendaPesquisa.setDataInicialDate(this.view.jDpesquisaDataInicio.getDate());
        this.agendaPesquisa.setStatus(this.view.jCpesquisaStatus.getSelectedItem().toString());
        this.agendaPesquisa.setIdColaborador(this.comboBoxColaboradoresPesquisa.getIdSelecionado());
        this.agendaPesquisa.pesquisar();
    }

    public void habilitaCampos() {
        UsuarioModelo usuarioModelo = Login.getLoginModeloLogado();
        boolean isRecepcaoOuOperacional = usuarioModelo.isRecepcao() || usuarioModelo.isOperacional();
        this.view.jBatalhoAgenda.setEnabled(isRecepcaoOuOperacional);
        this.view.jDpesquisaDataInicio.setEnabled(isRecepcaoOuOperacional);
        this.view.jCpesquisaColaborador.setEnabled(isRecepcaoOuOperacional);
        this.view.jBPesquisarefreshCadastroColaborador.setEnabled(isRecepcaoOuOperacional);
        this.view.jCpesquisaStatus.setEnabled(isRecepcaoOuOperacional);
        this.view.jMagenda.setEnabled(isRecepcaoOuOperacional);
        this.view.jBpesquisa.setEnabled(isRecepcaoOuOperacional);
        this.view.jBpesquisaReseta.setEnabled(isRecepcaoOuOperacional);
        this.view.jCpaginador.setEnabled(isRecepcaoOuOperacional);
        this.view.jBpaginador.setEnabled(isRecepcaoOuOperacional);
        this.view.jBatalhoClientes.setEnabled(isRecepcaoOuOperacional);
        this.view.jBatalhoTratamentos.setEnabled(isRecepcaoOuOperacional);
        if (!isRecepcaoOuOperacional) {
            this.view.jTresultados.setModel(new DefaultTableModel());
        }
        this.view.jBatalhoFinanceiro.setEnabled(usuarioModelo.isFinanceiro());
        this.view.jMenuFinanceiro.setEnabled(usuarioModelo.isFinanceiro());
        this.view.jBatalhoColaboradores.setEnabled(usuarioModelo.isAdmin());
        this.view.jMatalhoConfiguracoes.setEnabled(usuarioModelo.isAdmin());
    }
}

