/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.receita;

import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.configuracoes.PastasSistema;
import br.com.salomaotech.genesys.model.receita.ReceitaGeraPdf;
import br.com.salomaotech.genesys.model.receita.ReceitaModelo;
import br.com.salomaotech.genesys.model.receita.ReceitaPesquisa;
import br.com.salomaotech.genesys.view.JFreceita;
import br.com.salomaotech.sistema.algoritmos.BigDecimais;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class ReceitaMetodos {
    private final JFreceita view;
    private final long idCliente;

    public ReceitaMetodos(JFreceita view, long idCliente) {
        this.view = view;
        this.idCliente = idCliente;
    }

    public void popularFormulario(ReceitaModelo receitaModelo) {
        this.view.setId(receitaModelo.getId());
        this.view.jDcadastroData.setCalendar(receitaModelo.getData());
        this.view.setIdCliente(receitaModelo.getIdCliente());
        this.view.jCcadastroMedicamento.getEditor().setItem(receitaModelo.getMedicamento());
        this.view.jTcadastroQuantidade.setText(receitaModelo.getQuantidade().toString());
        this.view.jCcadastroMedida.setSelectedItem(receitaModelo.getMedida());
        this.view.jTcadastroPosologia.setText(receitaModelo.getPosologia());
    }

    public void resetarView() {
        this.popularFormulario(new ReceitaModelo());
        this.view.jCcadastroMedida.setSelectedIndex(0);
        this.view.jTcadastroQuantidade.setText(null);
    }

    public void resetarViewPesquisa() {
        this.view.jDpesquisaData.setDate(null);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.pesquisar();
    }

    public void habilitarCampos() {
        this.view.jBcadastroExcluir.setEnabled(this.view.getId() != 0L);
        this.view.jBatalhoImprimir.setEnabled(this.view.getId() != 0L);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jCcadastroMedicamento);
        popUp.adicionarMenu(this.view.jTcadastroQuantidade);
        popUp.adicionarMenu(this.view.jTcadastroPosologia);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new ReceitaModelo());
        ReceitaModelo receitaModelo = (ReceitaModelo)repository.findById(id);
        this.popularFormulario(receitaModelo);
        this.habilitarCampos();
        this.view.jTabaPrincipal.setSelectedIndex(0);
    }

    public ReceitaModelo salvar() {
        ReceitaModelo receitaModelo = new ReceitaModelo();
        receitaModelo.setId(this.view.getId());
        receitaModelo.setData(this.view.jDcadastroData.getCalendar());
        receitaModelo.setIdCliente(this.idCliente);
        receitaModelo.setMedicamento(this.view.jCcadastroMedicamento.getEditor().getItem().toString());
        receitaModelo.setQuantidade(BigDecimais.formatarParaBigDecimal(this.view.jTcadastroQuantidade.getText()));
        receitaModelo.setMedida(this.view.jCcadastroMedida.getSelectedItem().toString());
        receitaModelo.setPosologia(this.view.jTcadastroPosologia.getText());
        new Repository(receitaModelo).save();
        return receitaModelo;
    }

    public boolean excluir() {
        new ReceitaGeraPdf(new PastasSistema().getSubPastaImpressao(), this.view.getId()).excluir();
        return new Repository(new ReceitaModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        ReceitaPesquisa receitaPesquisa = new ReceitaPesquisa(this.view.jTresultados, this.idCliente, this.view.jCpaginador);
        receitaPesquisa.setData(this.view.jDpesquisaData.getDate());
        receitaPesquisa.pesquisar();
    }

    public void apresentaDadosCliente() {
        ClienteModelo clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.idCliente);
        this.view.jTnomeClienteApresentaNome.setText(clienteModelo.getNome());
        this.view.jTnomeClienteApresentaTelefone.setText(clienteModelo.getTelefone());
    }

    public void gerarPdf() {
        ReceitaGeraPdf receitaGeraPdf = new ReceitaGeraPdf(new PastasSistema().getSubPastaImpressao(), this.view.getId());
        receitaGeraPdf.gerar();
    }
}

