/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.receita;

import br.com.salomaotech.genesys.view.JFreceita;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.IsStringNumeroValido;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;

public class ReceitaValidador {
    private final JFreceita view;
    private String mensagensErro = "";

    public ReceitaValidador(JFreceita view) {
        this.view = view;
    }

    public boolean isValido() {
        if (!Datas.isCalendarioValido(this.view.jDcadastroData.getCalendar())) {
            this.mensagensErro = "Data da emiss\u00e3o inv\u00e1lida.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            return false;
        }
        if (ValidaStringIsEmpty.isEmpty(this.view.jCcadastroMedicamento.getEditor().getItem().toString())) {
            this.mensagensErro = "Informe o medicamento.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jCcadastroMedicamento.requestFocus();
            return false;
        }
        if (!IsStringNumeroValido.isNumeroValido(this.view.jTcadastroQuantidade.getText())) {
            this.mensagensErro = "Quantidade inv\u00e1lida.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroQuantidade.requestFocus();
            return false;
        }
        if (ValidaStringIsEmpty.isEmpty(this.view.jTcadastroPosologia.getText())) {
            this.mensagensErro = "Informe a posologia.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroPosologia.requestFocus();
            return false;
        }
        return true;
    }

    public String getMensagensErro() {
        return this.mensagensErro;
    }
}

