/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.servico;

import br.com.salomaotech.genesys.model.servico.ServicoModelo;
import br.com.salomaotech.genesys.model.servico.ServicoPesquisa;
import br.com.salomaotech.genesys.view.JFservico;
import br.com.salomaotech.sistema.algoritmos.BigDecimais;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class ServicoMetodos {
    private final JFservico view;

    public ServicoMetodos(JFservico view) {
        this.view = view;
    }

    public void popularFormulario(ServicoModelo servicoModelo) {
        this.view.setId(servicoModelo.getId());
        this.view.jTcadastroNome.setText(servicoModelo.getNome());
        this.view.jTcadastroDescricao.setText(servicoModelo.getDescricao());
        this.view.jTcategoriaValor.setText(servicoModelo.getValor().toString());
        this.view.jCcadastroCategoria.getEditor().setItem(servicoModelo.getCategoria());
    }

    public void resetarView() {
        this.popularFormulario(new ServicoModelo());
    }

    public void resetarViewPesquisa() {
        this.view.jTpesquisaNome.setText(null);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.pesquisar();
    }

    public void habilitarCampos() {
        this.view.jBcadastroExcluir.setEnabled(this.view.getId() != 0L);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTcadastroNome);
        popUp.adicionarMenu(this.view.jTcadastroDescricao);
        popUp.adicionarMenu(this.view.jTcategoriaValor);
        popUp.adicionarMenu(this.view.jTpesquisaNome);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new ServicoModelo());
        ServicoModelo servicoModelo = (ServicoModelo)repository.findById(id);
        this.popularFormulario(servicoModelo);
        this.habilitarCampos();
        this.view.jTabaPrincipal.setSelectedIndex(0);
    }

    public ServicoModelo salvar() {
        ServicoModelo servicoModelo = new ServicoModelo();
        servicoModelo.setId(this.view.getId());
        servicoModelo.setNome(this.view.jTcadastroNome.getText());
        servicoModelo.setDescricao(this.view.jTcadastroDescricao.getText());
        servicoModelo.setValor(BigDecimais.formatarParaBigDecimal(this.view.jTcategoriaValor.getText()));
        servicoModelo.setCategoria(this.view.jCcadastroCategoria.getEditor().getItem().toString());
        new Repository(servicoModelo).save();
        return servicoModelo;
    }

    public boolean excluir() {
        return new Repository(new ServicoModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        ServicoPesquisa servicoPesquisa = new ServicoPesquisa(this.view.jTresultados, this.view.jCpaginador);
        servicoPesquisa.setNome(this.view.jTpesquisaNome.getText());
        servicoPesquisa.pesquisar();
    }
}

