/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.servico;

import br.com.salomaotech.genesys.model.servico.ServicoModelo;
import br.com.salomaotech.genesys.view.JFservico;
import br.com.salomaotech.sistema.algoritmos.IsStringNumeroValido;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;

public class ServicoValidador {
    private final JFservico view;
    private String mensagensErro = "";

    public ServicoValidador(JFservico view) {
        this.view = view;
    }

    public boolean isValido() {
        if (ValidaStringIsEmpty.isEmpty(this.view.jTcadastroNome.getText())) {
            this.mensagensErro = "Informe um nome.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroNome.requestFocus();
            return false;
        }
        JPQL jpql = new JPQL(new ServicoModelo());
        jpql.addParametroDiferente("id", this.view.getId());
        jpql.addParametroIgual("nome", this.view.jTcadastroNome.getText());
        if (!new Repository(new ServicoModelo()).getResults(jpql.construirSelect()).isEmpty()) {
            this.mensagensErro = "O nome j\u00e1 est\u00e1 sendo utilizado.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroNome.requestFocus();
            return false;
        }
        if (!IsStringNumeroValido.isNumeroValido(this.view.jTcategoriaValor.getText())) {
            this.mensagensErro = "Valor inv\u00e1lido.";
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcategoriaValor.requestFocus();
            return false;
        }
        return true;
    }

    public String getMensagensErro() {
        return this.mensagensErro;
    }
}

