/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.tratamento;

import br.com.salomaotech.genesys.controller.tratamento.TratamentoMetodos;
import br.com.salomaotech.genesys.controller.tratamento.TratamentoValidador;
import br.com.salomaotech.genesys.model.colaborador.ComboBoxColaboradores;
import br.com.salomaotech.genesys.model.servico.ComboBoxServico;
import br.com.salomaotech.genesys.model.tratamento.TratamentoModelo;
import br.com.salomaotech.genesys.view.JFtratamento;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class TratamentoEventos {
    private final JFtratamento view;
    private ComboBoxServico comboBoxServico;
    private ComboBoxColaboradores comboBoxColaboradores;
    private ComboBoxColaboradores comboBoxColaboradoresPesquisa;
    private TratamentoMetodos tratamentoMetodos;

    public TratamentoEventos(JFtratamento view) {
        this.view = view;
    }

    public void setComboBoxServico(ComboBoxServico comboBoxServico) {
        this.comboBoxServico = comboBoxServico;
    }

    public void setComboBoxColaboradores(ComboBoxColaboradores comboBoxColaboradores) {
        this.comboBoxColaboradores = comboBoxColaboradores;
    }

    public void setComboBoxColaboradoresPesquisa(ComboBoxColaboradores comboBoxColaboradoresPesquisa) {
        this.comboBoxColaboradoresPesquisa = comboBoxColaboradoresPesquisa;
    }

    private void selecionarAba() {
        this.view.jTabaPrincipal.setSelectedIndex(0);
        this.view.jTabaSecundaria.setSelectedIndex(0);
    }

    public void setTratamentoMetodos(TratamentoMetodos tratamentoMetodos) {
        this.tratamentoMetodos = tratamentoMetodos;
    }

    public void addEventos() {
        this.view.jBcadastroSalvar.addActionListener(e -> {
            TratamentoValidador tratamentoValidador = new TratamentoValidador(this.view);
            if (tratamentoValidador.isValido()) {
                TratamentoModelo tratamentoModelo = this.tratamentoMetodos.salvar();
                if (tratamentoModelo.getId() != 0L) {
                    this.tratamentoMetodos.popularFormulario(tratamentoModelo);
                    this.tratamentoMetodos.habilitarCampos();
                    this.tratamentoMetodos.pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro salvo com sucesso!");
                } else {
                    JOptionPane.showMessageDialog(null, "Falha ao tentar salvar registro.");
                }
            } else {
                JOptionPane.showMessageDialog(null, tratamentoValidador.getMensagensErro());
            }
        });
        this.view.jBcadastroExcluir.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Excluir registro?") == 0) {
                if (this.tratamentoMetodos.excluir()) {
                    this.tratamentoMetodos.resetarView();
                    this.tratamentoMetodos.habilitarCampos();
                    this.tratamentoMetodos.pesquisar();
                    JOptionPane.showMessageDialog(null, "Registro excluido!");
                } else {
                    JOptionPane.showMessageDialog(null, "Registro n\u00e3o excluido!");
                }
            }
        });
        this.view.jTresultados.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TratamentoEventos.this.selecionarAba();
                    TratamentoEventos.this.tratamentoMetodos.resetarViewCamposServico();
                    TratamentoEventos.this.tratamentoMetodos.abrirCadastro((Long)((TratamentoEventos)TratamentoEventos.this).view.jTresultados.getModel().getValueAt(((TratamentoEventos)TratamentoEventos.this).view.jTresultados.getSelectedRow(), 0));
                }
            }
        });
        this.view.jBatalhoCadastro.addActionListener(e -> {
            this.tratamentoMetodos.resetarView();
            this.tratamentoMetodos.habilitarCampos();
            this.selecionarAba();
        });
        this.view.jBatalhoPesquisa.addActionListener(e -> this.view.jTabaPrincipal.setSelectedIndex(1));
        this.view.jBpesquisa.addActionListener(e -> this.tratamentoMetodos.pesquisar());
        this.view.jBtratamentoAdicionaItem.addActionListener(e -> this.tratamentoMetodos.adicionarItemServicoNaLista());
        this.view.jBtratamentoRemoveItem.addActionListener(e -> this.tratamentoMetodos.removerItemServicoNaLista());
        this.view.jTtratamentoItens.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TratamentoEventos.this.tratamentoMetodos.habilitarCamposDeExcluirServicoAdicionado();
            }
        });
        this.view.jTtratamentoItens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TratamentoEventos.this.tratamentoMetodos.habilitarCamposDeExcluirServicoAdicionado();
            }
        });
        this.view.jCtratamentoProcedimento.addActionListener(e -> this.tratamentoMetodos.habilitarCamposDeAdicionarServicoAdicionado());
        this.view.jBtratamentoLimpaItem.addActionListener(e -> this.tratamentoMetodos.resetarViewCamposServico());
        this.view.jBatalhoAprovar.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Ao finalizar um procedimento n\u00e3o ser\u00e1 mais poss\u00edvel edit\u00e1-lo, deseja continuar?") == 0) {
                TratamentoValidador tratamentoValidador = new TratamentoValidador(this.view);
                if (tratamentoValidador.isValido()) {
                    TratamentoModelo tratamentoModelo = this.tratamentoMetodos.aprovar();
                    if (tratamentoModelo.getId() != 0L) {
                        this.tratamentoMetodos.popularFormulario(tratamentoModelo);
                        this.tratamentoMetodos.habilitarCampos();
                        this.tratamentoMetodos.pesquisar();
                        JOptionPane.showMessageDialog(null, "Or\u00e7amento finalizado com sucesso! Verifique o seu financeiro.");
                        this.selecionarAba();
                    } else {
                        JOptionPane.showMessageDialog(null, "Falha ao tentar salvar or\u00e7amento.");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, tratamentoValidador.getMensagensErro());
                }
            }
        });
        this.view.jBrefreshCadastroProcedimento.addActionListener(e -> this.comboBoxServico.preencher());
        this.view.jBpaginador.addActionListener(e -> this.tratamentoMetodos.pesquisar());
        this.view.jBpesquisaReseta.addActionListener(e -> this.tratamentoMetodos.resetarViewPesquisa());
        this.view.jBrefreshCadastroColaborador.addActionListener(e -> this.comboBoxColaboradores.preencher());
        this.view.jBPesquisarefreshCadastroColaborador.addActionListener(e -> this.comboBoxColaboradoresPesquisa.preencher());
    }
}

