/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.tratamento;

import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.colaborador.ComboBoxColaboradores;
import br.com.salomaotech.genesys.model.evolucao.EvolucaoMovimenta;
import br.com.salomaotech.genesys.model.financeiro.FinanceiroMovimenta;
import br.com.salomaotech.genesys.model.login.Login;
import br.com.salomaotech.genesys.model.servico.ComboBoxServico;
import br.com.salomaotech.genesys.model.servico.ServicoModelo;
import br.com.salomaotech.genesys.model.tratamento.TratamentoModelo;
import br.com.salomaotech.genesys.model.tratamento.TratamentoModeloItem;
import br.com.salomaotech.genesys.model.tratamento.TratamentoPesquisa;
import br.com.salomaotech.genesys.model.usuario.UsuarioModelo;
import br.com.salomaotech.genesys.view.JFtratamento;
import br.com.salomaotech.sistema.algoritmos.ConverteNumeroParaMoedaBr;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class TratamentoMetodos {
    private final JFtratamento view;
    private final long idCliente;
    private boolean finalizado = false;
    private ComboBoxServico comboBoxServico;
    private ComboBoxColaboradores comboBoxColaboradores;
    private final List<TratamentoModeloItem> tratamentoModeloItemList = new ArrayList<TratamentoModeloItem>();
    private ComboBoxColaboradores comboBoxColaboradoresPesquisa;

    public TratamentoMetodos(JFtratamento view, long idCliente) {
        this.view = view;
        this.idCliente = idCliente;
    }

    public void setComboBoxServico(ComboBoxServico comboBoxServico) {
        this.comboBoxServico = comboBoxServico;
    }

    public void setComboBoxColaboradores(ComboBoxColaboradores comboBoxColaboradores) {
        this.comboBoxColaboradores = comboBoxColaboradores;
    }

    public void setComboBoxColaboradoresPesquisa(ComboBoxColaboradores comboBoxColaboradoresPesquisa) {
        this.comboBoxColaboradoresPesquisa = comboBoxColaboradoresPesquisa;
    }

    public void exibirTratamentosSelecionados() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.view.jTtratamentoItens.getModel();
        defaultTableModel.setNumRows(0);
        int contador = 0;
        for (TratamentoModeloItem tratamentoModeloItem : this.tratamentoModeloItemList) {
            ServicoModelo servicoModelo = (ServicoModelo)new Repository(new ServicoModelo()).findById(tratamentoModeloItem.getIdServico());
            Object[] linhaDefaultTableModel = new Object[]{servicoModelo.getNome(), ConverteNumeroParaMoedaBr.converter(tratamentoModeloItem.getValor().toString())};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
        this.view.jTtratamentoValorTotal.setText(ConverteNumeroParaMoedaBr.converter(this.calcularValorTotal().toString()));
    }

    private BigDecimal calcularValorTotal() {
        TratamentoModelo tratamentoModelo = new TratamentoModelo();
        tratamentoModelo.setTratamentoModeloItemList(this.tratamentoModeloItemList);
        return tratamentoModelo.getValorTotal();
    }

    public void resetarViewCamposServico() {
        this.comboBoxServico.selecionarItemPorId(0L);
    }

    public void habilitarCamposDeExcluirServicoAdicionado() {
        this.view.jBtratamentoRemoveItem.setEnabled(this.view.jTtratamentoItens.getSelectedRow() != -1);
    }

    public void habilitarCamposDeAdicionarServicoAdicionado() {
        boolean isProcedimentoSelecionado = this.view.jCtratamentoProcedimento.getSelectedIndex() != 0;
        this.view.jBtratamentoAdicionaItem.setEnabled(isProcedimentoSelecionado);
    }

    public void popularFormulario(TratamentoModelo tratamentoModelo) {
        this.view.setId(tratamentoModelo.getId());
        this.view.jDprocedimentoData.setCalendar(tratamentoModelo.getData());
        this.view.jTpagamentoObservacao.setText(tratamentoModelo.getObservacao());
        this.view.jCpagamentoForma.setSelectedItem(tratamentoModelo.getFormaPagamento());
        this.comboBoxColaboradores.selecionarItemPorId(tratamentoModelo.getIdColaborador());
    }

    public void resetarView() {
        this.popularFormulario(new TratamentoModelo());
        this.finalizado = false;
        this.tratamentoModeloItemList.clear();
        this.exibirTratamentosSelecionados();
        this.resetarViewCamposServico();
        this.comboBoxColaboradores.selecionarItemPorId(0L);
    }

    public void resetarViewPesquisa() {
        this.view.jDpesquisaData.setDate(null);
        this.view.jCpesquisaFinalizado.setSelectedIndex(0);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.comboBoxColaboradoresPesquisa.selecionarItemPorId(0L);
        this.pesquisar();
    }

    public void habilitarCampos() {
        TratamentoModelo tratamentoModelo = (TratamentoModelo)new Repository(new TratamentoModelo()).findById(this.view.getId());
        UsuarioModelo usuarioModelo = Login.getLoginModeloLogado();
        boolean isAdminOuOperacional = usuarioModelo.isAdmin() || usuarioModelo.isOperacional();
        this.view.jBatalhoCadastro.setEnabled(isAdminOuOperacional);
        this.view.jBcadastroSalvar.setEnabled(isAdminOuOperacional && !tratamentoModelo.isFinalizado());
        this.view.jBatalhoAprovar.setEnabled(isAdminOuOperacional && !tratamentoModelo.isFinalizado());
        this.view.jBcadastroExcluir.setEnabled(isAdminOuOperacional && tratamentoModelo.getId() != 0L);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTpagamentoObservacao);
    }

    public void abrirCadastro(long id) {
        TratamentoModelo tratamentoModelo = (TratamentoModelo)new Repository(new TratamentoModelo()).findById(id);
        this.popularFormulario(tratamentoModelo);
        this.habilitarCampos();
        this.finalizado = tratamentoModelo.isFinalizado();
        this.tratamentoModeloItemList.clear();
        for (TratamentoModeloItem tratamentoModeloItem : tratamentoModelo.getTratamentoModeloItemList()) {
            this.tratamentoModeloItemList.add(tratamentoModeloItem);
        }
        this.exibirTratamentosSelecionados();
    }

    public TratamentoModelo salvar() {
        TratamentoModelo tratamentoModelo = new TratamentoModelo();
        tratamentoModelo.setId(this.view.getId());
        tratamentoModelo.setData(this.view.jDprocedimentoData.getCalendar());
        tratamentoModelo.setTratamentoModeloItemList(this.tratamentoModeloItemList);
        tratamentoModelo.setFinalizado(this.finalizado);
        tratamentoModelo.setObservacao(this.view.jTpagamentoObservacao.getText());
        tratamentoModelo.setFormaPagamento(String.valueOf(this.view.jCpagamentoForma.getSelectedItem()));
        tratamentoModelo.setIdCliente(this.idCliente);
        tratamentoModelo.setIdColaborador(this.comboBoxColaboradores.getIdSelecionado());
        new Repository(tratamentoModelo).save();
        return tratamentoModelo;
    }

    public boolean excluir() {
        TratamentoModelo tratamentoModelo = (TratamentoModelo)new Repository(new TratamentoModelo()).findById(this.view.getId());
        new FinanceiroMovimenta(tratamentoModelo).remover();
        new EvolucaoMovimenta().remover(tratamentoModelo);
        return new Repository(new TratamentoModelo()).delete(tratamentoModelo.getId());
    }

    public void pesquisar() {
        TratamentoPesquisa tratamentoPesquisa = new TratamentoPesquisa(this.view.jTresultados, this.idCliente, this.view.jCpaginador);
        tratamentoPesquisa.setData(this.view.jDpesquisaData.getDate());
        tratamentoPesquisa.setIdColaborador(this.comboBoxColaboradoresPesquisa.getIdSelecionado());
        if (!ValidaStringIsEmpty.isEmpty(this.view.jCpesquisaFinalizado.getSelectedItem())) {
            tratamentoPesquisa.setFinalizado(String.valueOf(this.view.jCpesquisaFinalizado.getSelectedItem()));
        }
        tratamentoPesquisa.pesquisar();
    }

    public void adicionarItemServicoNaLista() {
        ServicoModelo servicoModelo = (ServicoModelo)new Repository(new ServicoModelo()).findById(this.comboBoxServico.getIdSelecionado());
        TratamentoModeloItem tratamentoModeloItem = new TratamentoModeloItem();
        tratamentoModeloItem.setIdServico(servicoModelo.getId());
        tratamentoModeloItem.setValor(servicoModelo.getValor());
        this.tratamentoModeloItemList.add(tratamentoModeloItem);
        this.exibirTratamentosSelecionados();
        this.resetarViewCamposServico();
    }

    public void removerItemServicoNaLista() {
        try {
            this.tratamentoModeloItemList.remove(this.view.jTtratamentoItens.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exibirTratamentosSelecionados();
        this.habilitarCamposDeExcluirServicoAdicionado();
    }

    public TratamentoModelo aprovar() {
        this.finalizado = true;
        TratamentoModelo tratamentoModelo = this.salvar();
        FinanceiroMovimenta financeiroMovimenta = new FinanceiroMovimenta(tratamentoModelo);
        financeiroMovimenta.remover();
        financeiroMovimenta.adicionar();
        new EvolucaoMovimenta().adicionar(tratamentoModelo);
        return tratamentoModelo;
    }

    public void apresentaDadosCliente() {
        ClienteModelo clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.idCliente);
        this.view.jTnomeClienteApresentaNome.setText(clienteModelo.getNome());
        this.view.jTnomeClienteApresentaTelefone.setText(clienteModelo.getTelefone());
    }
}

