/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.tratamento.pesquisa_avancada;

import br.com.salomaotech.genesys.model.cliente.ComboBoxClientes;
import br.com.salomaotech.genesys.model.colaborador.ComboBoxColaboradores;
import br.com.salomaotech.genesys.model.tratamento.pesquisa_avancada.TratamentoPesquisaAvancada;
import br.com.salomaotech.genesys.view.JFtratamentoPesquisa;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;

public class TratamentoPesquisaAvancadaMetodos {
    private final JFtratamentoPesquisa view;
    private final ComboBoxColaboradores comboBoxColaboradoresPesquisa;
    private final ComboBoxClientes comboBoxClientesPesquisa;

    public TratamentoPesquisaAvancadaMetodos(JFtratamentoPesquisa view, ComboBoxColaboradores comboBoxColaboradoresPesquisa, ComboBoxClientes comboBoxClientesPesquisa) {
        this.view = view;
        this.comboBoxColaboradoresPesquisa = comboBoxColaboradoresPesquisa;
        this.comboBoxClientesPesquisa = comboBoxClientesPesquisa;
    }

    public void resetarViewPesquisa() {
        this.view.jTabaPesquisa.setSelectedIndex(0);
        this.view.jDpesquisaDataInicio.setDate(null);
        this.view.jDPesquisaDataFim.setDate(null);
        this.view.jCpesquisaFinalizado.setSelectedIndex(0);
        this.view.jCpaginador.setSelectedIndex(-1);
        this.comboBoxColaboradoresPesquisa.selecionarItemPorId(0L);
        this.comboBoxClientesPesquisa.selecionarItemPorId(0L);
        this.pesquisar();
    }

    public void pesquisar() {
        TratamentoPesquisaAvancada tratamentoPesquisa = new TratamentoPesquisaAvancada(this.view.jTresultados, this.view.jCpaginador);
        tratamentoPesquisa.setDataInicialDate(this.view.jDpesquisaDataInicio.getDate());
        tratamentoPesquisa.setDataFinalDate(this.view.jDPesquisaDataFim.getDate());
        tratamentoPesquisa.setIdColaborador(this.comboBoxColaboradoresPesquisa.getIdSelecionado());
        tratamentoPesquisa.setIdCliente(this.comboBoxClientesPesquisa.getIdSelecionado());
        if (!ValidaStringIsEmpty.isEmpty(this.view.jCpesquisaFinalizado.getSelectedItem())) {
            tratamentoPesquisa.setFinalizado(String.valueOf(this.view.jCpesquisaFinalizado.getSelectedItem()));
        }
        tratamentoPesquisa.pesquisar();
    }
}

