/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.usuario;

import br.com.salomaotech.genesys.controller.usuario.UsuarioMetodos;
import br.com.salomaotech.genesys.controller.usuario.UsuarioValidador;
import br.com.salomaotech.genesys.model.usuario.UsuarioModelo;
import br.com.salomaotech.genesys.model.usuario.UsuarioPesquisa;
import br.com.salomaotech.genesys.view.JFusuario;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;

public class UsuarioEventos {
    private final JFusuario view;
    private UsuarioMetodos usuarioMetodos;

    public UsuarioEventos(JFusuario view) {
        this.view = view;
    }

    public void setUsuarioMetodos(UsuarioMetodos usuarioMetodos) {
        this.usuarioMetodos = usuarioMetodos;
    }

    public void addEventos() {
        this.view.jBcadastroSalvar.addActionListener(e -> {
            UsuarioValidador usuarioValidador = new UsuarioValidador(this.view);
            if (usuarioValidador.isValido()) {
                UsuarioModelo usuarioModelo = this.usuarioMetodos.salvar();
                if (usuarioModelo.getId() != 0L) {
                    this.usuarioMetodos.popularFormulario(usuarioModelo);
                    this.usuarioMetodos.habilitarCampos();
                    new UsuarioPesquisa(this.view.jTresultados).pesquisar();
                    JOptionPane.showMessageDialog(null, "Usu\u00e1rio salvo! Use-o para entrar e lembre-se de guardar a senha em um local seguro.");
                    this.view.jTcadastroLogin.requestFocus();
                } else {
                    JOptionPane.showMessageDialog(null, "Falha ao tentar salvar registro.");
                }
            } else {
                JOptionPane.showMessageDialog(null, usuarioValidador.getMensagensErro());
            }
        });
        this.view.jBcadastroExcluir.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(null, "Excluir registro?") == 0) {
                if (this.usuarioMetodos.excluir()) {
                    this.usuarioMetodos.resetarView();
                    this.usuarioMetodos.habilitarCampos();
                    new UsuarioPesquisa(this.view.jTresultados).pesquisar();
                    this.view.jTcadastroLogin.requestFocus();
                    JOptionPane.showMessageDialog(null, "Registro excluido!");
                } else {
                    JOptionPane.showMessageDialog(null, "Registro n\u00e3o excluido!");
                }
            }
        });
        this.view.jTresultados.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ((UsuarioEventos)UsuarioEventos.this).view.jTabaPrincipal.setSelectedIndex(0);
                    UsuarioEventos.this.usuarioMetodos.abrirCadastro((Long)((UsuarioEventos)UsuarioEventos.this).view.jTresultados.getModel().getValueAt(((UsuarioEventos)UsuarioEventos.this).view.jTresultados.getSelectedRow(), 0));
                    UsuarioEventos.this.usuarioMetodos.habilitarCampos();
                }
            }
        });
        this.view.jBatalhoCadastro.addActionListener(e -> {
            this.usuarioMetodos.resetarView();
            this.usuarioMetodos.habilitarCampos();
            this.view.jTabaPrincipal.setSelectedIndex(0);
            this.view.jTcadastroLogin.requestFocus();
        });
        this.view.jBatalhoPesquisa.addActionListener(e -> this.view.jTabaPrincipal.setSelectedIndex(1));
    }
}

