/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.usuario;

import br.com.salomaotech.genesys.model.usuario.UsuarioModelo;
import br.com.salomaotech.genesys.model.usuario.UsuarioPesquisa;
import br.com.salomaotech.genesys.view.JFusuario;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.PopUp;

public class UsuarioMetodos {
    private final JFusuario view;

    public UsuarioMetodos(JFusuario view) {
        this.view = view;
    }

    public void popularFormulario(UsuarioModelo usuarioModelo) {
        this.view.setId(usuarioModelo.getId());
        this.view.jTcadastroLogin.setText(usuarioModelo.getLogin());
        this.view.jTcadastroSenha.setText(usuarioModelo.getSenha());
        this.view.jCcadastroAdministrador.setSelected(usuarioModelo.isAdmin());
        this.view.jCcadastroRecepcao.setSelected(usuarioModelo.isRecepcao());
        this.view.jCcadastroFinanceiro.setSelected(usuarioModelo.isFinanceiro());
        this.view.jCcadastroOperacional.setSelected(usuarioModelo.isOperacional());
    }

    public void resetarView() {
        this.popularFormulario(new UsuarioModelo());
    }

    public void habilitarCampos() {
        boolean isIdAberto = this.view.getId() != 0L;
        this.view.jBcadastroExcluir.setEnabled(isIdAberto);
    }

    public void addPopUpMenu() {
        PopUp popUp = new PopUp();
        popUp.adicionarMenu(this.view.jTcadastroLogin);
        popUp.adicionarMenu(this.view.jTcadastroSenha);
    }

    public void abrirCadastro(long id) {
        Repository repository = new Repository(new UsuarioModelo());
        UsuarioModelo usuarioModelo = (UsuarioModelo)repository.findById(id);
        this.popularFormulario(usuarioModelo);
    }

    public UsuarioModelo salvar() {
        UsuarioModelo usuarioModelo = new UsuarioModelo();
        usuarioModelo.setId(this.view.getId());
        usuarioModelo.setLogin(this.view.jTcadastroLogin.getText());
        usuarioModelo.setSenha(this.view.jTcadastroSenha.getText());
        usuarioModelo.setAdmin(this.view.jCcadastroAdministrador.isSelected());
        usuarioModelo.setRecepcao(this.view.jCcadastroRecepcao.isSelected());
        usuarioModelo.setFinanceiro(this.view.jCcadastroFinanceiro.isSelected());
        usuarioModelo.setOperacional(this.view.jCcadastroOperacional.isSelected());
        new Repository(usuarioModelo).save();
        return usuarioModelo;
    }

    public boolean excluir() {
        return new Repository(new UsuarioModelo()).delete(this.view.getId());
    }

    public void pesquisar() {
        UsuarioPesquisa usuarioPesquisa = new UsuarioPesquisa(this.view.jTresultados);
        usuarioPesquisa.pesquisar();
    }
}

