/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.controller.usuario;

import br.com.salomaotech.genesys.model.usuario.UsuarioModelo;
import br.com.salomaotech.genesys.view.JFusuario;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;

public class UsuarioValidador {
    private final JFusuario view;
    private String mensagensErro = "";

    public UsuarioValidador(JFusuario view) {
        this.view = view;
    }

    public boolean isValido() {
        if (ValidaStringIsEmpty.isEmpty(this.view.jTcadastroLogin.getText())) {
            this.mensagensErro = "Informe um login.";
            this.view.jTcadastroLogin.requestFocus();
            return false;
        }
        JPQL jpql = new JPQL(new UsuarioModelo());
        jpql.addParametroDiferente("id", this.view.getId());
        jpql.addParametroIgual("login", this.view.jTcadastroLogin.getText());
        if (!new Repository(new UsuarioModelo()).getResults(jpql.construirSelect()).isEmpty()) {
            this.mensagensErro = "O login j\u00e1 est\u00e1 sendo utilizado.";
            this.view.jTcadastroLogin.requestFocus();
            return false;
        }
        if (ValidaStringIsEmpty.isEmpty(this.view.jTcadastroSenha.getText())) {
            this.mensagensErro = "Informe uma senha.";
            this.view.jTcadastroSenha.requestFocus();
            return false;
        }
        return true;
    }

    public String getMensagensErro() {
        return this.mensagensErro;
    }
}

