/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.agenda;

import br.com.salomaotech.genesys.model.agenda.AgendaModelo;
import br.com.salomaotech.genesys.model.colaborador.ColaboradorModelo;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.MudaCorLinhaJtable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class AgendaPesquisa {
    private Date dataInicialDate;
    private Date dataFinalDate;
    private String nomeCliente;
    private String status;
    private final JTable jTresultados;
    private final JComboBox jCpaginador;
    private boolean isDataAnterior;
    private long idColaborador;

    public AgendaPesquisa(JTable jTresultados, JComboBox jCpaginador) {
        this.jTresultados = jTresultados;
        this.jCpaginador = jCpaginador;
    }

    private void popularDados(List<AgendaModelo> agendaModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        ArrayList<Color> colorList = new ArrayList<Color>();
        int contador = 0;
        for (AgendaModelo agendaModelo : agendaModeloList) {
            String nomeColaborador = "";
            if (agendaModelo.getIdColaborador() != 0L) {
                ColaboradorModelo colaboradorModelo = (ColaboradorModelo)new Repository(new ColaboradorModelo()).findById(agendaModelo.getIdColaborador());
                nomeColaborador = colaboradorModelo.getNome() + " - " + colaboradorModelo.getRegistro();
            }
            Object[] linhaDefaultTableModel = new Object[]{agendaModelo.getId(), Datas.calendarParaStringBr(agendaModelo.getDataAgenda()), agendaModelo.getDataHora() + ":" + agendaModelo.getDataMinuto(), agendaModelo.getNomeCliente(), agendaModelo.getTelefone(), nomeColaborador, agendaModelo.getStatus()};
            Calendar dataCompleta = (Calendar)agendaModelo.getDataAgenda().clone();
            dataCompleta.set(11, Integer.parseInt(agendaModelo.getDataHora()));
            dataCompleta.set(12, Integer.parseInt(agendaModelo.getDataMinuto()));
            dataCompleta.set(13, 0);
            dataCompleta.set(14, 0);
            Calendar dataAgoraCalendar = Calendar.getInstance();
            dataAgoraCalendar.set(13, 0);
            dataAgoraCalendar.set(14, 0);
            if (dataCompleta.compareTo(dataAgoraCalendar) == -1) {
                colorList.add(Color.decode("#e4b7bc"));
            } else {
                colorList.add(Color.decode("#b2ddc3"));
            }
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
        MudaCorLinhaJtable.mudar(this.jTresultados, colorList);
    }

    public void setDataInicialDate(Date dataInicialDate) {
        this.dataInicialDate = dataInicialDate;
    }

    public void setDataFinalDate(Date dataFinalDate) {
        this.dataFinalDate = dataFinalDate;
    }

    public void setNomeCliente(String nomeCliente) {
        this.nomeCliente = nomeCliente;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setIsDataAnterior(boolean isDataAnterior) {
        this.isDataAnterior = isDataAnterior;
    }

    public void setIdColaborador(long idColaborador) {
        this.idColaborador = idColaborador;
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new AgendaModelo());
        jpql.addParametroLike("nomeCliente", this.nomeCliente);
        jpql.addOrderBy("dataAgenda", "ASC");
        jpql.addOrderBy("dataHora", "ASC");
        jpql.addOrderBy("dataMinuto", "ASC");
        jpql.addOrderBy("id", "ASC");
        if (this.isDataAnterior) {
            jpql.addParametroMenorIgual("dataAgenda", this.dataInicialDate);
        } else if (!Objects.isNull(this.dataInicialDate) && !Objects.isNull(this.dataFinalDate)) {
            jpql.addParametroMaiorIgual("dataAgenda", this.dataInicialDate);
            jpql.addParametroMenorIgual("dataAgenda", this.dataFinalDate);
        } else {
            if (!Objects.isNull(this.dataInicialDate)) {
                jpql.addParametroIgual("dataAgenda", this.dataInicialDate);
            }
            if (!Objects.isNull(this.dataFinalDate)) {
                jpql.addParametroMenorIgual("dataAgenda", this.dataFinalDate);
            }
        }
        if (!ValidaStringIsEmpty.isEmpty(this.status) && !this.status.equals("Todos")) {
            jpql.addParametroIgual("status", this.status);
        }
        if (this.idColaborador > 0L) {
            jpql.addParametroIgual("idColaborador", this.idColaborador);
        }
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new AgendaModelo());
        Repository repository = new Repository(new AgendaModelo());
        List agendaModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(agendaModeloList);
    }
}

