/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.anamnese;

import br.com.salomaotech.genesys.model.anamnese.AnamneseModelo;
import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.configuracoes.PastasCliente;
import br.com.salomaotech.genesys.model.empresa.EmpresaModelo;
import br.com.salomaotech.genesys.model.empresa.EmpresaPesquisa;
import br.com.salomaotech.genesys.model.empresa.ImagemEmpresa;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.ExecutaProgramaExterno;
import br.com.salomaotech.sistema.algoritmos.GerarPdf3;
import br.com.salomaotech.sistema.jpa.Repository;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.JOptionPane;

public class AnamneseGerarPdf {
    private final AnamneseModelo anamneseModelo;
    private final ClienteModelo clienteModelo;
    private final GerarPdf3 gerarPdf3;
    private final EmpresaModelo empresaModelo = EmpresaPesquisa.getDadosEmpresa();
    private final Font fonteCorpo = new Font(Font.FontFamily.COURIER, 12.0f, 0);
    private final Image imagemLogotipo;

    public AnamneseGerarPdf(long id) {
        this.anamneseModelo = (AnamneseModelo)new Repository(new AnamneseModelo()).findById(id);
        this.clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.anamneseModelo.getIdCliente());
        this.imagemLogotipo = ImagemEmpresa.getImagemLogotipo(String.valueOf(this.empresaModelo.getId()));
        this.gerarPdf3 = new GerarPdf3(this.getLocalArquivo());
    }

    private String getLocalArquivo() {
        LocalDateTime agora = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        String pathArquivo = agora.format(formatter);
        pathArquivo = new PastasCliente(String.valueOf(this.anamneseModelo.getIdCliente())).getSubPastaAnamnese() + "/" + pathArquivo + "/Anamnese";
        return pathArquivo;
    }

    public void addEmpresaTopo() {
        Paragraph paragrafoTitulo = new Paragraph();
        Chunk textoTitulo = new Chunk("Ficha de avalia\u00e7\u00e3o Anamnese", new Font(Font.FontFamily.COURIER, 22.0f, 1));
        if (this.imagemLogotipo != null) {
            Paragraph paragraphImagem = new Paragraph();
            paragraphImagem.add(new Chunk(this.imagemLogotipo, 0.0f, -90.0f));
            paragraphImagem.setAlignment(0);
            this.gerarPdf3.addConteudo(paragraphImagem);
            Font fonteInfo = new Font(Font.FontFamily.COURIER, 12.0f, 1);
            Paragraph paragraphEmpresa = new Paragraph("Cl\u00ednica: " + this.empresaModelo.getNome() + "   Fone: " + this.empresaModelo.getTelefone(), fonteInfo);
            paragraphEmpresa.setAlignment(2);
            this.gerarPdf3.addConteudo(paragraphEmpresa);
            textoTitulo.setTextRise(-20.0f);
            paragrafoTitulo.add(textoTitulo);
            paragrafoTitulo.setAlignment(2);
        } else {
            Font fonteInfo = new Font(Font.FontFamily.COURIER, 14.0f, 1);
            Paragraph paragraphEmpresa = new Paragraph("Cl\u00ednica: " + this.empresaModelo.getNome() + "   Fone: " + this.empresaModelo.getTelefone(), fonteInfo);
            paragraphEmpresa.setAlignment(1);
            this.gerarPdf3.addConteudo(paragraphEmpresa);
            textoTitulo.setTextRise(-30.0f);
            paragrafoTitulo.add(textoTitulo);
            paragrafoTitulo.setAlignment(1);
        }
        this.gerarPdf3.addConteudo(paragrafoTitulo);
    }

    public void addPacienteTopo() {
        if (this.imagemLogotipo != null) {
            this.gerarPdf3.addConteudo(new Paragraph("\n\n\n\n"));
        } else {
            this.gerarPdf3.addConteudo(new Paragraph("\n\n\n"));
        }
        String dadosPaciente = "Paciente: " + this.clienteModelo.getNome() + "\nCPF: " + this.clienteModelo.getCpf() + "   Nascimento: " + Datas.calendarParaStringBr(this.clienteModelo.getNascimento()) + "   Fone: " + this.clienteModelo.getTelefone() + "";
        Font fonteCorpoBold = new Font(this.fonteCorpo.getFamily(), this.fonteCorpo.getSize(), 1);
        this.gerarPdf3.addConteudo(new Paragraph(dadosPaciente, fonteCorpoBold));
        this.gerarPdf3.addConteudo(new Paragraph("\n\n"));
    }

    public void addCorpo() {
        this.gerarPdf3.addConteudo(new Paragraph("Est\u00e1 em tratamento m\u00e9dico: " + (this.anamneseModelo.isResposta1() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Qual?___________________________________________________________________", this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("\n"));
        this.gerarPdf3.addConteudo(new Paragraph("Est\u00e1 fazendo algum regime: " + (this.anamneseModelo.isResposta3() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Qual?___________________________________________________________________", this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("\n"));
        this.gerarPdf3.addConteudo(new Paragraph("Tem alergias: " + (this.anamneseModelo.isResposta5() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Qual?___________________________________________________________________", this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("\n"));
        this.gerarPdf3.addConteudo(new Paragraph("Alergia a medicamento: " + (this.anamneseModelo.isResposta10() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Qual?___________________________________________________________________", this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("\n"));
        this.gerarPdf3.addConteudo(new Paragraph("Est\u00e1 gr\u00e1vida: " + (this.anamneseModelo.isResposta2() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Possui diab\u00e9tes: " + (this.anamneseModelo.isResposta4() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Tem hepatite: " + (this.anamneseModelo.isResposta11() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("\u00c9 portador do v\u00edrus HIV: " + (this.anamneseModelo.isResposta12() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Usa ou j\u00e1 usou drogas: " + (this.anamneseModelo.isResposta13() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Fumante: " + (this.anamneseModelo.isResposta14() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Doen\u00e7a cardiovascular: " + (this.anamneseModelo.isResposta15() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Doen\u00e7as respirat\u00f3rias: " + this.anamneseModelo.getResposta17(), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Doen\u00e7as na fam\u00edlia: " + this.anamneseModelo.getResposta18(), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Febre reum\u00e1tica: " + (this.anamneseModelo.isResposta6() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Problemas de coagula\u00e7\u00e3o: " + (this.anamneseModelo.isResposta7() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Problemas hemorr\u00e1gicos: " + (this.anamneseModelo.isResposta8() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Problemas com anestes\u00eda: " + (this.anamneseModelo.isResposta9() ? "SIM" : "N\u00c3O"), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Press\u00e3o arterial: " + this.anamneseModelo.getResposta16(), this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Informa\u00e7\u00f5es adicionais: " + this.anamneseModelo.getResposta19(), this.fonteCorpo));
    }

    public void addRodape() {
        this.gerarPdf3.addConteudo(new Paragraph("\n\n\n"));
        this.gerarPdf3.addConteudo(new Paragraph("Assinatura do paciente: ________________________________________________", this.fonteCorpo));
        this.gerarPdf3.addConteudo(new Paragraph("Data: ____/____/________", this.fonteCorpo));
    }

    public boolean gerarPdf() {
        this.addEmpresaTopo();
        this.addPacienteTopo();
        this.addCorpo();
        this.addRodape();
        if (this.gerarPdf3.gerar()) {
            ExecutaProgramaExterno.executarModoDesktop(this.gerarPdf3.getPathDeSaidaDoArquivo());
            return true;
        }
        JOptionPane.showMessageDialog(null, "Falha ao gerar Anamnese!");
        return false;
    }
}

