/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.atestado;

import br.com.salomaotech.genesys.model.atestado.AtestadoModelo;
import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.empresa.EmpresaModelo;
import br.com.salomaotech.genesys.model.empresa.EmpresaPesquisa;
import br.com.salomaotech.genesys.model.empresa.ImagemEmpresa;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.ExecutaProgramaExterno;
import br.com.salomaotech.sistema.algoritmos.GerarPdf3;
import br.com.salomaotech.sistema.jpa.Repository;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import java.io.File;
import java.util.Objects;
import javax.swing.JOptionPane;

public class AtestadoGeraPdf {
    private final GerarPdf3 gerarPdf3;
    private final EmpresaModelo empresaModelo = EmpresaPesquisa.getDadosEmpresa();
    private final AtestadoModelo atestadoModelo;
    private final ClienteModelo clienteModelo;
    private final String pathDestino;
    private final Image imagemLogotipo;

    public AtestadoGeraPdf(String pathDestino, long idAtestado) {
        this.pathDestino = pathDestino + "atestado_" + idAtestado;
        this.gerarPdf3 = new GerarPdf3(this.pathDestino);
        this.atestadoModelo = (AtestadoModelo)new Repository(new AtestadoModelo()).findById(idAtestado);
        this.clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.atestadoModelo.getIdCliente());
        this.imagemLogotipo = ImagemEmpresa.getImagemLogotipo(String.valueOf(this.empresaModelo.getId()));
    }

    public void addEmpresaTopo() {
        Paragraph paragrafoTitulo = new Paragraph();
        Chunk textoTitulo = new Chunk("ATESTADO M\u00c9DICO", new Font(Font.FontFamily.COURIER, 22.0f, 1));
        if (this.imagemLogotipo != null) {
            Paragraph paragraphImagem = new Paragraph();
            paragraphImagem.add(new Chunk(this.imagemLogotipo, 0.0f, -90.0f));
            paragraphImagem.setAlignment(0);
            this.gerarPdf3.addConteudo(paragraphImagem);
            Font fonteInfo = new Font(Font.FontFamily.COURIER, 12.0f, 1);
            Paragraph paragraphEmpresa = new Paragraph("Cl\u00ednica: " + this.empresaModelo.getNome() + "   Fone: " + this.empresaModelo.getTelefone(), fonteInfo);
            paragraphEmpresa.setAlignment(2);
            this.gerarPdf3.addConteudo(paragraphEmpresa);
            textoTitulo.setTextRise(-20.0f);
            paragrafoTitulo.add(textoTitulo);
            paragrafoTitulo.setAlignment(2);
        } else {
            Font fonteInfo = new Font(Font.FontFamily.COURIER, 14.0f, 1);
            Paragraph paragraphEmpresa = new Paragraph("Cl\u00ednica: " + this.empresaModelo.getNome() + "   Fone: " + this.empresaModelo.getTelefone(), fonteInfo);
            paragraphEmpresa.setAlignment(1);
            this.gerarPdf3.addConteudo(paragraphEmpresa);
            textoTitulo.setTextRise(-30.0f);
            paragrafoTitulo.add(textoTitulo);
            paragrafoTitulo.setAlignment(1);
        }
        this.gerarPdf3.addConteudo(paragrafoTitulo);
    }

    private void addAtestado() {
        this.gerarPdf3.addConteudo(new Paragraph("\n\n\n\n"));
        String horarioInicio = this.atestadoModelo.getHoraInicio() + ":" + this.atestadoModelo.getMinutoInicio();
        String horarioFim = this.atestadoModelo.getHoraFim() + ":" + this.atestadoModelo.getMinutoFim();
        if (Objects.isNull(this.clienteModelo.getCpf())) {
            this.clienteModelo.setCpf("000.000.000-00");
        }
        String conteudo = "\nAtesto, com o fim espec\u00edfico de dispensa de atividades trabalhistas (ou escolares, ou judici\u00e1rias), que " + this.clienteModelo.getNome() + ", portador(a) do CPF " + this.clienteModelo.getCpf() + " esteve sob meus cuidados profissionais no dia ";
        conteudo = this.atestadoModelo.getDias() != 0 ? conteudo + Datas.calendarParaStringBr(this.atestadoModelo.getData()) + " devendo permanecer em repouso por " + this.atestadoModelo.getDias() + " dia(s)." : conteudo + Datas.calendarParaStringBr(this.atestadoModelo.getData()) + " das " + horarioInicio + " \u00e1s " + horarioFim + ".";
        this.gerarPdf3.addConteudo(new Paragraph(conteudo, new Font(Font.FontFamily.HELVETICA, 11.0f, 0)));
    }

    private void addRodape() {
        int i;
        String assinaturaProfissional = "PROFISSIONAL, ______________________________________________";
        Paragraph assinaturaProfissionalParagraph = new Paragraph(assinaturaProfissional, new Font(Font.FontFamily.HELVETICA, 11.0f, 0));
        assinaturaProfissionalParagraph.setAlignment(1);
        String dataBr = Datas.calendarParaStringBr(this.atestadoModelo.getData());
        Paragraph dataParagraph = new Paragraph(dataBr, new Font(Font.FontFamily.HELVETICA, 11.0f, 0));
        dataParagraph.setAlignment(1);
        String assinaturaPaciente = "EU, _________________________________________________________\nautorizo que meu diagnostico (CID) esteja presente neste atestado.\nCID: " + this.atestadoModelo.getCid();
        Paragraph assinaturaPacienteParagraph = new Paragraph(assinaturaPaciente, new Font(Font.FontFamily.HELVETICA, 11.0f, 0));
        assinaturaPacienteParagraph.setAlignment(1);
        for (i = 0; i <= 18; ++i) {
            this.gerarPdf3.addConteudo(new Paragraph("\n"));
        }
        this.gerarPdf3.addConteudo(assinaturaProfissionalParagraph);
        this.gerarPdf3.addConteudo(dataParagraph);
        for (i = 0; i <= 5; ++i) {
            this.gerarPdf3.addConteudo(new Paragraph("\n"));
        }
        this.gerarPdf3.addConteudo(assinaturaPacienteParagraph);
    }

    public boolean gerar() {
        this.addEmpresaTopo();
        this.addAtestado();
        this.addRodape();
        if (this.gerarPdf3.gerar()) {
            ExecutaProgramaExterno.executarModoDesktop(this.gerarPdf3.getPathDeSaidaDoArquivo());
            return true;
        }
        JOptionPane.showMessageDialog(null, "Falha ao gerar atestado!");
        return false;
    }

    public boolean excluir() {
        try {
            return new File(this.pathDestino + ".pdf").delete();
        }
        catch (Exception ex) {
            return false;
        }
    }
}

