/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.atestado;

import br.com.salomaotech.genesys.model.atestado.AtestadoModelo;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class AtestadoPesquisa {
    private final JTable jTresultados;
    private final long idCliente;
    private final JComboBox jCpaginador;
    private Date data;

    public AtestadoPesquisa(JTable jTresultados, long idCliente, JComboBox jCpaginador) {
        this.jTresultados = jTresultados;
        this.idCliente = idCliente;
        this.jCpaginador = jCpaginador;
    }

    private void popularDados(List<AtestadoModelo> atestadoModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        int contador = 0;
        for (AtestadoModelo atestadoModelo : atestadoModeloList) {
            String horarioInicio = atestadoModelo.getHoraInicio() + ":" + atestadoModelo.getMinutoInicio();
            String horarioFim = atestadoModelo.getHoraFim() + ":" + atestadoModelo.getMinutoFim();
            Object[] linhaDefaultTableModel = new Object[]{atestadoModelo.getId(), Datas.calendarParaStringBr(atestadoModelo.getData()), atestadoModelo.getDias(), horarioInicio, horarioFim, atestadoModelo.getCid()};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new AtestadoModelo());
        jpql.addParametroIgual("idCliente", this.idCliente);
        jpql.addOrderBy("data", "ASC");
        jpql.addOrderBy("id", "ASC");
        if (!Objects.isNull(this.data)) {
            jpql.addParametroIgual("data", this.data);
        }
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new AtestadoModelo());
        Repository repository = new Repository(new AtestadoModelo());
        List atestadoModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(atestadoModeloList);
    }
}

