/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.ativador;

import br.com.salomaotech.sistema.algoritmos.CriaPastaLocal;
import br.com.salomaotech.sistema.algoritmos.HashMd5;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Objects;
import java.util.Properties;

public class Ativador {
    private String pathArquivo = System.getProperty("user.dir") + "/target/arquivos/lck/";
    private String nomeDoArquivo = HashMd5.cifrar("KEY_PROP_NOME_ARQUIVO");
    private String pathArquivoCompleto = this.pathArquivo + this.nomeDoArquivo + ".lck";
    private Properties propriedades = new Properties();
    private String chavePropAtivacao = HashMd5.cifrar("KEY_PROP_1");
    private String chavePropNumeroAberturas = HashMd5.cifrar("KEY_PROP_2");
    private String chavePropDataUltimaAbertura = HashMd5.cifrar("KEY_PROP_3");
    private int numeroMaximoDeChaves = 10000;
    private String dataHoje;
    private int diasMaximoVersaoDemo = 5;
    private String preFixoDaChaveDeAtivacao = HashMd5.cifrar("+_PREFIX_CHAVE_ATIVACAO_+");
    private String posFixoDaChaveDeAtivacao = HashMd5.cifrar("*_POSFIX_CHAVE_ATIVACAO_*");
    private String ativadoTrue = HashMd5.cifrar("KEY_PROP_ATIVADO_TRUE");
    private String ativadoFalse = HashMd5.cifrar("KEY_PROP_ATIVADO_FALSE");
    private String nomeSistema = "";

    public Ativador(String nomeSistema) {
        if (!Objects.isNull(nomeSistema)) {
            this.nomeSistema = HashMd5.cifrar(nomeSistema);
        }
        CriaPastaLocal.criar(this.pathArquivo);
        try {
            this.dataHoje = new SimpleDateFormat("yyyy/MM/dd").format(Calendar.getInstance().getTime());
            if (!new File(this.pathArquivoCompleto).exists()) {
                new File(this.pathArquivoCompleto).createNewFile();
            }
            this.propriedades.load(new FileInputStream(this.pathArquivoCompleto));
            if (Objects.isNull(this.propriedades.getProperty(this.chavePropAtivacao))) {
                this.propriedades.setProperty(this.chavePropAtivacao, HashMd5.cifrar(this.ativadoFalse));
            }
            if (Objects.isNull(this.propriedades.getProperty(this.chavePropNumeroAberturas))) {
                this.propriedades.setProperty(this.chavePropNumeroAberturas, HashMd5.cifrar("1"));
            }
            if (Objects.isNull(this.propriedades.getProperty(this.chavePropDataUltimaAbertura))) {
                this.propriedades.setProperty(this.chavePropDataUltimaAbertura, this.dataHoje);
            }
            if (!this.isAtivado()) {
                if (!this.propriedades.get(this.chavePropDataUltimaAbertura).equals(this.dataHoje)) {
                    String incrementaDia = String.valueOf(this.getDiasUsados() + 1);
                    this.propriedades.setProperty(this.chavePropNumeroAberturas, HashMd5.cifrar(incrementaDia));
                }
                this.propriedades.setProperty(this.chavePropAtivacao, HashMd5.cifrar(this.ativadoFalse));
                this.propriedades.setProperty(this.chavePropDataUltimaAbertura, this.dataHoje);
                this.salvarArquivo();
            }
        }
        catch (IOException | NullPointerException | NumberFormatException exception) {
            // empty catch block
        }
    }

    private void salvarArquivo() {
        Properties novasPropriedades = new Properties();
        novasPropriedades.setProperty(this.chavePropAtivacao, this.propriedades.getProperty(this.chavePropAtivacao));
        novasPropriedades.setProperty(this.chavePropNumeroAberturas, this.propriedades.getProperty(this.chavePropNumeroAberturas));
        novasPropriedades.setProperty(this.chavePropDataUltimaAbertura, this.propriedades.getProperty(this.chavePropDataUltimaAbertura));
        for (int i = 0; i <= 10000; ++i) {
            String dataAgora = Calendar.getInstance().getTime().toString();
            String chave = HashMd5.cifrar("CHK_" + dataAgora + i);
            String valor = HashMd5.cifrar("VAL_" + dataAgora + i);
            novasPropriedades.setProperty(chave, valor);
        }
        try {
            novasPropriedades.store(new FileOutputStream(this.pathArquivoCompleto), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final int getDiasUsados() {
        int i = 1;
        while (!this.propriedades.getProperty(this.chavePropNumeroAberturas).equals(HashMd5.cifrar(String.valueOf(i)))) {
            ++i;
        }
        return i;
    }

    public int getDiasRestantes() {
        int diasRestantes = this.diasMaximoVersaoDemo - this.getDiasUsados();
        if (diasRestantes <= 0) {
            diasRestantes = 0;
        }
        return diasRestantes;
    }

    public boolean isExpirou() {
        if (this.isAtivado()) {
            return false;
        }
        return this.getDiasRestantes() <= 0;
    }

    public final boolean isAtivado() {
        return this.propriedades.getProperty(this.chavePropAtivacao).equals(HashMd5.cifrar(this.ativadoTrue));
    }

    public ArrayList getChaves() {
        ArrayList<String> retorno = new ArrayList<String>();
        for (int i = 0; i <= this.numeroMaximoDeChaves; ++i) {
            retorno.add(HashMd5.cifrar(this.preFixoDaChaveDeAtivacao + i + this.nomeSistema + this.posFixoDaChaveDeAtivacao));
        }
        return retorno;
    }

    public boolean ativar(String chave) {
        if (chave != null) {
            chave = chave.trim();
        }
        if (this.getChaves().contains(chave)) {
            this.propriedades.setProperty(this.chavePropAtivacao, HashMd5.cifrar(this.ativadoTrue));
            this.salvarArquivo();
            return true;
        }
        return false;
    }

    public String getPathArquivoCompleto() {
        return this.pathArquivoCompleto;
    }
}

