/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.centro_custo;

import br.com.salomaotech.genesys.model.centro_custo.CentroCustoModelo;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComboBox;

public class ComboBoxCentroCusto {
    private final JComboBox jComboBox;
    private List<CentroCustoModelo> centroCustoModeloList = new ArrayList<CentroCustoModelo>();
    private final LinkedHashMap cadastroCentroCustosMap = new LinkedHashMap();
    private long idCentroCustoSelecionado;

    public ComboBoxCentroCusto(JComboBox jComboBox) {
        this.jComboBox = jComboBox;
        this.idCentroCustoSelecionado = 0L;
        this.addEventos();
    }

    private JPQL popularJpql() {
        JPQL jpql = new JPQL(new CentroCustoModelo());
        jpql.addOrderBy("codigo", "ASC");
        jpql.addOrderBy("nome", "ASC");
        return jpql;
    }

    private void addEventos() {
        this.jComboBox.addActionListener(e -> {
            try {
                this.idCentroCustoSelecionado = (Long)this.cadastroCentroCustosMap.get(this.jComboBox.getSelectedItem());
            }
            catch (Exception ex) {
                this.idCentroCustoSelecionado = 0L;
            }
        });
    }

    public void preencher() {
        this.jComboBox.removeAllItems();
        this.jComboBox.addItem("");
        this.centroCustoModeloList = new Repository(new CentroCustoModelo()).getResults(this.popularJpql().construirSelect());
        this.centroCustoModeloList.forEach(centroCusto -> {
            this.jComboBox.addItem(centroCusto.getNomeCompleto());
            this.cadastroCentroCustosMap.put(centroCusto.getNomeCompleto(), centroCusto.getId());
        });
    }

    public void selecionarItemPorId(long idCentroCusto) {
        this.jComboBox.setSelectedItem("");
        this.centroCustoModeloList = new Repository(new CentroCustoModelo()).getResults(this.popularJpql().construirSelect());
        this.centroCustoModeloList.forEach(centroCusto -> {
            if (centroCusto.getId() == idCentroCusto) {
                this.jComboBox.setSelectedItem(centroCusto.getNomeCompleto());
                this.idCentroCustoSelecionado = idCentroCusto;
            }
        });
    }

    public long getIdSelecionado() {
        return this.idCentroCustoSelecionado;
    }
}

