/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.cliente;

import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.patterns.Command;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;

public class ComboBoxClientes {
    private final JComboBox jComboBox;
    private List<ClienteModelo> clienteModeloList = new ArrayList<ClienteModelo>();
    private final LinkedHashMap cadastroDeClientesMap = new LinkedHashMap();
    private final Command command;
    private long idClienteSelecionado;

    public ComboBoxClientes(JComboBox jComboBox) {
        this(jComboBox, null);
    }

    public ComboBoxClientes(JComboBox jComboBox, Command command) {
        this.jComboBox = jComboBox;
        this.command = command;
        this.idClienteSelecionado = 0L;
        this.addEventos();
    }

    private JPQL popularJpql() {
        JPQL jpql = new JPQL(new ClienteModelo());
        jpql.addOrderBy("nome", "ASC");
        return jpql;
    }

    private void addEventos() {
        this.jComboBox.addActionListener(e -> {
            try {
                this.idClienteSelecionado = (Long)this.cadastroDeClientesMap.get(this.jComboBox.getSelectedItem());
            }
            catch (Exception ex) {
                this.idClienteSelecionado = 0L;
            }
            if (!Objects.isNull(this.command)) {
                this.command.executar(this.idClienteSelecionado);
            }
        });
    }

    public void preencher() {
        this.jComboBox.removeAllItems();
        this.jComboBox.addItem("");
        this.clienteModeloList = new Repository(new ClienteModelo()).getResults(this.popularJpql().construirSelect());
        this.clienteModeloList.forEach(cliente -> {
            String nomeComTelefone = cliente.getNome() + " - " + cliente.getTelefone();
            this.jComboBox.addItem(nomeComTelefone);
            this.cadastroDeClientesMap.put(nomeComTelefone, cliente.getId());
        });
    }

    public void selecionarItemPorId(long idCliente) {
        this.jComboBox.setSelectedItem("");
        this.clienteModeloList = new Repository(new ClienteModelo()).getResults(this.popularJpql().construirSelect());
        this.clienteModeloList.forEach(cliente -> {
            if (cliente.getId() == idCliente) {
                String nomeComTelefone = cliente.getNome() + " - " + cliente.getTelefone();
                this.jComboBox.setSelectedItem(nomeComTelefone);
                this.idClienteSelecionado = idCliente;
                if (!Objects.isNull(this.command)) {
                    this.command.executar(this.idClienteSelecionado);
                }
            }
        });
    }

    public long getIdSelecionado() {
        return this.idClienteSelecionado;
    }
}

