/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.colaborador;

import br.com.salomaotech.genesys.model.colaborador.ColaboradorModelo;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ColaboradorPesquisa {
    private final JTable jTresultados;
    private final JComboBox jCpaginador;
    private String nome;
    private String telefone;

    public ColaboradorPesquisa(JTable jTresultados, JComboBox jCpaginador) {
        this.jTresultados = jTresultados;
        this.jCpaginador = jCpaginador;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    private void popularDados(List<ColaboradorModelo> colaboradorModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        int contador = 0;
        for (ColaboradorModelo colaboradorModelo : colaboradorModeloList) {
            Object[] linhaDefaultTableModel = new Object[]{colaboradorModelo.getId(), colaboradorModelo.getNome(), colaboradorModelo.getTelefone(), colaboradorModelo.getEmail()};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new ColaboradorModelo());
        jpql.addParametroLike("nome", this.nome);
        jpql.addParametroLike("telefone", this.telefone);
        jpql.addOrderBy("nome", "ASC");
        jpql.addOrderBy("id", "ASC");
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new ColaboradorModelo());
        Repository repository = new Repository(new ColaboradorModelo());
        List colaboradorModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(colaboradorModeloList);
    }
}

