/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.colaborador;

import br.com.salomaotech.genesys.model.colaborador.ColaboradorModelo;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.patterns.Command;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;

public class ComboBoxColaboradores {
    private final JComboBox jComboBox;
    private List<ColaboradorModelo> colaboradorModeloList = new ArrayList<ColaboradorModelo>();
    private final LinkedHashMap cadastroDeColaboradorsMap = new LinkedHashMap();
    private final Command command;
    private long idColaboradorSelecionado;

    public ComboBoxColaboradores(JComboBox jComboBox) {
        this(jComboBox, null);
    }

    public ComboBoxColaboradores(JComboBox jComboBox, Command command) {
        this.jComboBox = jComboBox;
        this.command = command;
        this.idColaboradorSelecionado = 0L;
        this.addEventos();
    }

    private JPQL popularJpql() {
        JPQL jpql = new JPQL(new ColaboradorModelo());
        jpql.addOrderBy("nome", "ASC");
        return jpql;
    }

    private void addEventos() {
        this.jComboBox.addActionListener(e -> {
            try {
                this.idColaboradorSelecionado = (Long)this.cadastroDeColaboradorsMap.get(this.jComboBox.getSelectedItem());
            }
            catch (Exception ex) {
                this.idColaboradorSelecionado = 0L;
            }
            if (!Objects.isNull(this.command)) {
                this.command.executar(this.idColaboradorSelecionado);
            }
        });
    }

    public void preencher() {
        this.jComboBox.removeAllItems();
        this.jComboBox.addItem("");
        this.colaboradorModeloList = new Repository(new ColaboradorModelo()).getResults(this.popularJpql().construirSelect());
        this.colaboradorModeloList.forEach(colaborador -> {
            String nome = colaborador.getNome();
            this.jComboBox.addItem(nome);
            this.cadastroDeColaboradorsMap.put(nome, colaborador.getId());
        });
    }

    public void selecionarItemPorId(long idColaborador) {
        this.jComboBox.setSelectedItem("");
        this.colaboradorModeloList = new Repository(new ColaboradorModelo()).getResults(this.popularJpql().construirSelect());
        this.colaboradorModeloList.forEach(colaborador -> {
            if (colaborador.getId() == idColaborador) {
                String nome = colaborador.getNome();
                this.jComboBox.setSelectedItem(nome);
                this.idColaboradorSelecionado = idColaborador;
                if (!Objects.isNull(this.command)) {
                    this.command.executar(this.idColaboradorSelecionado);
                }
            }
        });
    }

    public long getIdSelecionado() {
        return this.idColaboradorSelecionado;
    }
}

