/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.evolucao;

import br.com.salomaotech.genesys.model.evolucao.EvolucaoModelo;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class EvolucaoPesquisa {
    private final JTable jTresultados;
    private final long idCliente;
    private final JComboBox jCpaginador;
    private String descricao;

    public EvolucaoPesquisa(JTable jTresultados, long idCliente, JComboBox jCpaginador) {
        this.jTresultados = jTresultados;
        this.idCliente = idCliente;
        this.jCpaginador = jCpaginador;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    private void popularDados(List<EvolucaoModelo> evolucaoModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        int contador = 0;
        for (EvolucaoModelo evolucaoModelo : evolucaoModeloList) {
            Object[] linhaDefaultTableModel = new Object[]{evolucaoModelo.getId(), Datas.calendarParaStringBr(evolucaoModelo.getData()), evolucaoModelo.getDescricao()};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new EvolucaoModelo());
        jpql.addParametroIgual("idCliente", this.idCliente);
        jpql.addParametroLike("descricao", this.descricao);
        jpql.addOrderBy("data", "ASC");
        jpql.addOrderBy("id", "ASC");
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new EvolucaoModelo());
        Repository repository = new Repository(new EvolucaoModelo());
        List evolucaoModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(evolucaoModeloList);
    }
}

