/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.financeiro;

import br.com.salomaotech.genesys.model.centro_custo.CentroCustoModelo;
import br.com.salomaotech.genesys.model.financeiro.FinanceiroModelo;
import br.com.salomaotech.genesys.model.tratamento.TratamentoModelo;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;

public class FinanceiroMovimenta {
    private final TratamentoModelo tratamentoModelo;

    public FinanceiroMovimenta(TratamentoModelo tratamentoModelo) {
        this.tratamentoModelo = tratamentoModelo;
    }

    private long retornaIdCentroCustoTratamento() {
        try {
            JPQL jpql = new JPQL(new CentroCustoModelo());
            jpql.addParametroIgual("codigo", "2.1.3");
            List centroCustoModelo = new Repository(new CentroCustoModelo()).getResults(jpql.construirSelect());
            return ((CentroCustoModelo)centroCustoModelo.get(0)).getId();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    private void cadastrarFinanceiro(Calendar data, BigDecimal valor, String descricao) {
        FinanceiroModelo financeiroModelo = new FinanceiroModelo();
        financeiroModelo.setData(data);
        financeiroModelo.setValor(valor);
        financeiroModelo.setDescricao(descricao);
        financeiroModelo.setIsDespesa(false);
        financeiroModelo.setIdTratamento(this.tratamentoModelo.getId());
        financeiroModelo.setIdCliente(this.tratamentoModelo.getIdCliente());
        financeiroModelo.setIsPago(true);
        financeiroModelo.setIdCentroCusto(this.retornaIdCentroCustoTratamento());
        new Repository(financeiroModelo).save();
    }

    public void adicionar() {
        if (!Objects.isNull(new Repository(new TratamentoModelo()).findById(this.tratamentoModelo.getId()))) {
            this.cadastrarFinanceiro(this.tratamentoModelo.getData(), this.tratamentoModelo.getValorTotal(), "Tratamento c\u00f3digo: " + this.tratamentoModelo.getId());
        }
    }

    public void remover() {
        if (!Objects.isNull(new Repository(new TratamentoModelo()).findById(this.tratamentoModelo.getId()))) {
            JPQL jpql = new JPQL(new FinanceiroModelo());
            jpql.addParametroIgual("idTratamento", this.tratamentoModelo.getId());
            List financeiroModeloList = new Repository(new FinanceiroModelo()).getResults(jpql.construirSelect());
            for (FinanceiroModelo financeiroModelo : financeiroModeloList) {
                new Repository(new FinanceiroModelo()).delete(financeiroModelo.getId());
            }
        }
    }
}

