/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.financeiro;

import br.com.salomaotech.genesys.model.centro_custo.CentroCustoModelo;
import br.com.salomaotech.genesys.model.financeiro.FinanceiroModelo;
import br.com.salomaotech.sistema.algoritmos.BigDecimais;
import br.com.salomaotech.sistema.algoritmos.ConverteNumeroParaMoedaBr;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import br.com.salomaotech.sistema.swing.MudaCorLinhaJtable;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class FinanceiroPesquisa {
    private final JTable jTresultados;
    private final JComboBox jCpaginador;
    private final JLabel labelSaldo;
    private Date dataInicialDate;
    private Date dataFinalDate;
    private String pagamentoRealizado;
    private String pagamentoDespesa;
    private boolean isDataAnterior;
    private long idTratamento;
    private long idCliente;
    private long idCentroCusto;

    public FinanceiroPesquisa(JTable jTresultados, JComboBox jCpaginador, JLabel labelSaldo) {
        this.jTresultados = jTresultados;
        this.jCpaginador = jCpaginador;
        this.labelSaldo = labelSaldo;
    }

    private void popularDados(List<FinanceiroModelo> financeiroModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        ArrayList<Color> colorList = new ArrayList<Color>();
        int contador = 0;
        BigDecimal saldoTotal = new BigDecimal(0);
        for (FinanceiroModelo financeiroModelo : financeiroModeloList) {
            BigDecimal valor;
            CentroCustoModelo centroCustoModelo = (CentroCustoModelo)new Repository(new CentroCustoModelo()).findById(financeiroModelo.getIdCentroCusto());
            String descricao = financeiroModelo.getDescricao();
            if (financeiroModelo.isIsDespesa()) {
                valor = financeiroModelo.getValor().negate();
                colorList.add(Color.decode("#e4b7bc"));
            } else {
                valor = financeiroModelo.getValor();
                colorList.add(Color.decode("#b2ddc3"));
            }
            saldoTotal = saldoTotal.add(valor);
            String situacao = financeiroModelo.isIsPago() ? (financeiroModelo.isIsDespesa() ? "Pago" : "Recebido") : "Em aberto";
            Object[] linhaDefaultTableModel = new Object[]{financeiroModelo.getId(), Datas.calendarParaStringBr(financeiroModelo.getData()), descricao, centroCustoModelo.getNomeCompleto(), situacao, ConverteNumeroParaMoedaBr.converter(valor.toString())};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
        MudaCorLinhaJtable.mudar(this.jTresultados, colorList);
        this.labelSaldo.setText(ConverteNumeroParaMoedaBr.converter(saldoTotal.toString()));
        if (BigDecimais.isNegativo(saldoTotal)) {
            this.labelSaldo.setForeground(Color.RED);
        } else {
            this.labelSaldo.setForeground(Color.decode("#008744"));
        }
    }

    public void setDataInicialDate(Date dataInicialDate) {
        this.dataInicialDate = dataInicialDate;
    }

    public void setDataFinalDate(Date dataFinalDate) {
        this.dataFinalDate = dataFinalDate;
    }

    public void setPagamentoRealizado(String pagamentoRealizado) {
        this.pagamentoRealizado = pagamentoRealizado;
    }

    public void setPagamentoDespesa(String pagamentoDespesa) {
        this.pagamentoDespesa = pagamentoDespesa;
    }

    public void setIsDataAnterior(boolean isDataAnterior) {
        this.isDataAnterior = isDataAnterior;
    }

    public void setIdTratamento(long idTratamento) {
        this.idTratamento = idTratamento;
    }

    public void setIdCliente(long idCliente) {
        this.idCliente = idCliente;
    }

    public void setIdCentroCusto(long idCentroCusto) {
        this.idCentroCusto = idCentroCusto;
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new FinanceiroModelo());
        jpql.addOrderBy("data", "ASC");
        jpql.addOrderBy("id", "ASC");
        if (this.isDataAnterior) {
            jpql.addParametroMenorIgual("data", this.dataInicialDate);
        } else if (!Objects.isNull(this.dataInicialDate) && !Objects.isNull(this.dataFinalDate)) {
            jpql.addParametroMaiorIgual("data", this.dataInicialDate);
            jpql.addParametroMenorIgual("data", this.dataFinalDate);
        } else {
            if (!Objects.isNull(this.dataInicialDate)) {
                jpql.addParametroIgual("data", this.dataInicialDate);
            }
            if (!Objects.isNull(this.dataFinalDate)) {
                jpql.addParametroMenorIgual("data", this.dataFinalDate);
            }
        }
        if (!Objects.isNull(this.pagamentoRealizado)) {
            switch (this.pagamentoRealizado) {
                case "Sim": {
                    jpql.addParametroIgual("isPago", true);
                    break;
                }
                case "Nao": {
                    jpql.addParametroIgual("isPago", false);
                }
            }
        }
        if (!Objects.isNull(this.pagamentoDespesa)) {
            switch (this.pagamentoDespesa) {
                case "Pagar": {
                    jpql.addParametroIgual("isDespesa", true);
                    break;
                }
                case "Receber": {
                    jpql.addParametroIgual("isDespesa", false);
                }
            }
        }
        if (this.idTratamento != 0L) {
            jpql.addOrderBy("idTratamento", "ASC");
            jpql.addParametroIgual("idTratamento", this.idTratamento);
        }
        if (this.idCliente != 0L) {
            jpql.addParametroIgual("idCliente", this.idCliente);
        }
        if (this.idCentroCusto != 0L) {
            jpql.addParametroIgual("idCentroCusto", this.idCentroCusto);
        }
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new FinanceiroModelo());
        Repository repository = new Repository(new FinanceiroModelo());
        List financeiroModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(financeiroModeloList);
    }
}

